/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import com.google.common.collect.ImmutableSet;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.rules.compatibility.AbstractCompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.SimpleCompatibilityDifference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;

public class AvroCompatibilityChecker
extends AbstractCompatibilityChecker<SchemaCompatibility.Incompatibility> {
    protected Set<SchemaCompatibility.Incompatibility> isBackwardsCompatibleWith(String existing, String proposed, Map<String, ContentHandle> resolvedReferences) {
        try {
            Schema.Parser existingParser = new Schema.Parser();
            for (ContentHandle schema : resolvedReferences.values()) {
                existingParser.parse(schema.content());
            }
            Schema existingSchema = existingParser.parse(existing);
            Schema.Parser proposingParser = new Schema.Parser();
            for (ContentHandle schema : resolvedReferences.values()) {
                proposingParser.parse(schema.content());
            }
            Schema proposedSchema = proposingParser.parse(proposed);
            SchemaCompatibility.SchemaCompatibilityResult result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)proposedSchema, (Schema)existingSchema).getResult();
            switch (result.getCompatibility()) {
                case COMPATIBLE: {
                    return Collections.emptySet();
                }
                case INCOMPATIBLE: {
                    return ImmutableSet.builder().addAll((Iterable)result.getIncompatibilities()).build();
                }
            }
            throw new IllegalStateException("Got illegal compatibility result: " + result.getCompatibility());
        }
        catch (AvroRuntimeException ex) {
            throw new UnprocessableSchemaException("Could not execute compatibility rule on invalid Avro schema", (Throwable)ex);
        }
    }

    protected CompatibilityDifference transform(SchemaCompatibility.Incompatibility original) {
        return new SimpleCompatibilityDifference(original.getMessage(), original.getLocation());
    }
}

