/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content;

import io.apicurio.registry.content.ContentAccepter;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.util.ContentTypeUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.avro.Schema;

public class AvroContentAccepter
implements ContentAccepter {
    private static final Pattern QUOTED_BRACKETS = Pattern.compile(": *\"\\{}\"");

    private static String removeQuotedBrackets(String content) {
        return QUOTED_BRACKETS.matcher(content).replaceAll(":{}");
    }

    public boolean acceptsContent(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            if (content.getContentType() != null && content.getContentType().toLowerCase().contains("json") && !ContentTypeUtil.isParsableJson((ContentHandle)content.getContent())) {
                return false;
            }
            Schema.Parser parser = new Schema.Parser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (Map.Entry<String, TypedContent> referencedContent : resolvedReferences.entrySet()) {
                if (parser.getTypes().containsKey(referencedContent.getKey())) continue;
                Schema schemaRef = parser.parse(referencedContent.getValue().getContent().content());
                schemaRefs.add(schemaRef);
            }
            Schema schema = parser.parse(AvroContentAccepter.removeQuotedBrackets(content.getContent().content()));
            schema.toString(schemaRefs, false);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

