/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.rules.compatibility.AbstractCompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.SimpleCompatibilityDifference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;

public class AvroCompatibilityChecker
extends AbstractCompatibilityChecker<SchemaCompatibility.Incompatibility> {
    protected Set<SchemaCompatibility.Incompatibility> isBackwardsCompatibleWith(String existing, String proposed, Map<String, TypedContent> resolvedReferences) {
        try {
            Schema.Parser existingParser = new Schema.Parser();
            for (TypedContent schema : resolvedReferences.values()) {
                existingParser.parse(schema.getContent().content());
            }
            Schema existingSchema = existingParser.parse(existing);
            Schema.Parser proposingParser = new Schema.Parser();
            for (TypedContent schema : resolvedReferences.values()) {
                proposingParser.parse(schema.getContent().content());
            }
            Schema proposedSchema = proposingParser.parse(proposed);
            SchemaCompatibility.SchemaCompatibilityResult result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)proposedSchema, (Schema)existingSchema).getResult();
            switch (result.getCompatibility()) {
                case COMPATIBLE: {
                    return Collections.emptySet();
                }
                case INCOMPATIBLE: {
                    HashSet all = new HashSet();
                    all.addAll(result.getIncompatibilities());
                    return Collections.unmodifiableSet(all);
                }
            }
            throw new IllegalStateException("Got illegal compatibility result: " + String.valueOf(result.getCompatibility()));
        }
        catch (Exception ex) {
            throw new UnprocessableSchemaException("Could not execute compatibility rule on invalid Avro schema", (Throwable)ex);
        }
    }

    protected CompatibilityDifference transform(SchemaCompatibility.Incompatibility original) {
        return new SimpleCompatibilityDifference(original.getMessage(), original.getLocation());
    }
}

