/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import com.google.common.collect.ImmutableSet;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class AbstractCompatibilityChecker<D>
implements CompatibilityChecker {
    @Override
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<ContentHandle> existingArtifacts, ContentHandle proposedArtifact, Map<String, ContentHandle> resolvedReferences) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingArtifacts, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedArtifact, "proposedSchema MUST NOT be null");
        if (existingArtifacts.isEmpty()) {
            return CompatibilityExecutionResult.compatible();
        }
        String proposedArtifactContent = proposedArtifact.content();
        ImmutableSet incompatibleDiffs = new HashSet();
        String lastExistingSchema = existingArtifacts.get(existingArtifacts.size() - 1).content();
        switch (compatibilityLevel) {
            case BACKWARD: {
                incompatibleDiffs = this.isBackwardsCompatibleWith(lastExistingSchema, proposedArtifactContent, resolvedReferences);
                break;
            }
            case BACKWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)existing, (String)proposed, resolvedReferences));
                break;
            }
            case FORWARD: {
                incompatibleDiffs = this.isBackwardsCompatibleWith(proposedArtifactContent, lastExistingSchema, resolvedReferences);
                break;
            }
            case FORWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)proposed, (String)existing, resolvedReferences));
                break;
            }
            case FULL: {
                incompatibleDiffs = ImmutableSet.builder().addAll(this.isBackwardsCompatibleWith(lastExistingSchema, proposedArtifactContent, resolvedReferences)).addAll(this.isBackwardsCompatibleWith(proposedArtifactContent, lastExistingSchema, resolvedReferences)).build();
                break;
            }
            case FULL_TRANSITIVE: {
                incompatibleDiffs = ImmutableSet.builder().addAll(this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)existing, (String)proposed, resolvedReferences))).addAll(this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)proposed, (String)existing, resolvedReferences))).build();
                break;
            }
        }
        Set<CompatibilityDifference> diffs = incompatibleDiffs.stream().map(this::transform).collect(Collectors.toSet());
        return CompatibilityExecutionResult.incompatibleOrEmpty(diffs);
    }

    private Set<D> transitively(List<ContentHandle> existingSchemas, String proposedSchema, BiFunction<String, String, Set<D>> checkExistingProposed) {
        HashSet<D> result = new HashSet<D>();
        for (int i = existingSchemas.size() - 1; i >= 0; --i) {
            Set<D> current = checkExistingProposed.apply(existingSchemas.get(i).content(), proposedSchema);
            result.addAll(current);
        }
        return result;
    }

    protected abstract Set<D> isBackwardsCompatibleWith(String var1, String var2, Map<String, ContentHandle> var3);

    protected abstract CompatibilityDifference transform(D var1);
}

