/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.SimpleCompatibilityDifference;
import java.util.Collections;
import java.util.Set;

public class CompatibilityExecutionResult {
    private final Set<CompatibilityDifference> incompatibleDifferences;

    private CompatibilityExecutionResult(Set<CompatibilityDifference> incompatibleDifferences) {
        this.incompatibleDifferences = incompatibleDifferences;
    }

    public boolean isCompatible() {
        return this.incompatibleDifferences == null || this.incompatibleDifferences.isEmpty();
    }

    public Set<CompatibilityDifference> getIncompatibleDifferences() {
        return this.incompatibleDifferences;
    }

    public static CompatibilityExecutionResult compatible() {
        return new CompatibilityExecutionResult(Collections.emptySet());
    }

    public static CompatibilityExecutionResult incompatibleOrEmpty(Set<CompatibilityDifference> incompatibleDifferences) {
        return new CompatibilityExecutionResult(incompatibleDifferences);
    }

    public static CompatibilityExecutionResult incompatible(Exception e) {
        SimpleCompatibilityDifference diff = new SimpleCompatibilityDifference(e.getMessage());
        return new CompatibilityExecutionResult(Collections.singleton(diff));
    }

    public static CompatibilityExecutionResult incompatible(String message) {
        SimpleCompatibilityDifference diff = new SimpleCompatibilityDifference(message);
        return new CompatibilityExecutionResult(Collections.singleton(diff));
    }
}

