/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content;

import io.apicurio.registry.content.ContentHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

abstract class AbstractContentHandle
implements ContentHandle {
    protected byte[] bytes;
    protected String content;

    AbstractContentHandle() {
    }

    @Override
    public InputStream stream() {
        return new ByteArrayInputStream(this.bytes());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentHandle)) {
            return false;
        }
        ContentHandle other = (ContentHandle)o;
        return Arrays.equals(this.bytes(), other.bytes());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes());
    }

    @Override
    public String toString() {
        return "ContentHandle{content='" + this.content() + "'}";
    }

    @Override
    public int getSizeBytes() {
        return this.bytes().length;
    }

    @Override
    public String getSha256Hash() {
        return DigestUtils.sha256Hex((byte[])this.bytes());
    }
}

