/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.refs;

import io.apicurio.registry.content.refs.ExternalReference;

public class JsonPointerExternalReference
extends ExternalReference {
    private static String toFullReference(String resource, String component) {
        if (resource == null) {
            return component;
        }
        if (component == null) {
            return resource;
        }
        return resource + component;
    }

    public JsonPointerExternalReference(String jsonPointer) {
        super(jsonPointer, JsonPointerExternalReference.resourceFrom(jsonPointer), JsonPointerExternalReference.componentFrom(jsonPointer));
    }

    public JsonPointerExternalReference(String resource, String component) {
        super(JsonPointerExternalReference.toFullReference(resource, component), resource, component);
    }

    private static String componentFrom(String jsonPointer) {
        int idx = jsonPointer.indexOf(35);
        if (idx == 0) {
            return jsonPointer;
        }
        if (idx > 0) {
            return jsonPointer.substring(idx);
        }
        return null;
    }

    private static String resourceFrom(String jsonPointer) {
        int idx = jsonPointer.indexOf(35);
        if (idx == 0) {
            return null;
        }
        if (idx > 0) {
            return jsonPointer.substring(0, idx);
        }
        return jsonPointer;
    }
}

