/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.types.RuleType;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class RuleViolationException
extends RegistryException {
    private static final long serialVersionUID = 8437151164241883773L;
    private final RuleType ruleType;
    private final Optional<String> ruleConfiguration;
    private final Set<RuleViolation> causes;

    public RuleViolationException(String message, RuleType ruleType, String ruleConfiguration, Throwable cause) {
        super(message, cause);
        this.ruleType = ruleType;
        this.ruleConfiguration = Optional.ofNullable(ruleConfiguration);
        this.causes = new HashSet<RuleViolation>();
    }

    public RuleViolationException(String message, RuleType ruleType, String ruleConfiguration, Set<RuleViolation> causes) {
        super(message);
        this.ruleType = ruleType;
        this.ruleConfiguration = Optional.ofNullable(ruleConfiguration);
        this.causes = causes;
    }

    public RuleViolationException(String message, RuleType ruleType, String ruleConfiguration, Set<RuleViolation> causes, Throwable cause) {
        super(message, cause);
        this.ruleType = ruleType;
        this.ruleConfiguration = Optional.ofNullable(ruleConfiguration);
        this.causes = causes;
    }

    public String getDetailMessage() {
        return super.getMessage() + this.causes.stream().map(rv -> rv.getDescription() + (String)(rv.getContext() != null && !rv.getContext().isBlank() ? " at " + rv.getContext() : "")).reduce((left, right) -> left + ", " + right).map(s -> " Causes: " + s).orElse("");
    }

    @Generated
    public RuleType getRuleType() {
        return this.ruleType;
    }

    @Generated
    public Optional<String> getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    @Generated
    public Set<RuleViolation> getCauses() {
        return this.causes;
    }
}

