/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class AbstractCompatibilityChecker<D>
implements CompatibilityChecker {
    @Override
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<TypedContent> existingArtifacts, TypedContent proposedArtifact, Map<String, TypedContent> resolvedReferences) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingArtifacts, "existingSchemas MUST NOT be null");
        Objects.requireNonNull(proposedArtifact, "proposedSchema MUST NOT be null");
        if (existingArtifacts.isEmpty()) {
            return CompatibilityExecutionResult.compatible();
        }
        String proposedArtifactContent = proposedArtifact.getContent().content();
        Set<Object> incompatibleDiffs = new HashSet();
        String lastExistingSchema = existingArtifacts.get(existingArtifacts.size() - 1).getContent().content();
        switch (compatibilityLevel) {
            case BACKWARD: {
                incompatibleDiffs = this.isBackwardsCompatibleWith(lastExistingSchema, proposedArtifactContent, resolvedReferences);
                break;
            }
            case BACKWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)existing, (String)proposed, resolvedReferences));
                break;
            }
            case FORWARD: {
                incompatibleDiffs = this.isBackwardsCompatibleWith(proposedArtifactContent, lastExistingSchema, resolvedReferences);
                break;
            }
            case FORWARD_TRANSITIVE: {
                incompatibleDiffs = this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)proposed, (String)existing, resolvedReferences));
                break;
            }
            case FULL: {
                incompatibleDiffs = this.unionOf(this.isBackwardsCompatibleWith(lastExistingSchema, proposedArtifactContent, resolvedReferences), this.isBackwardsCompatibleWith(proposedArtifactContent, lastExistingSchema, resolvedReferences));
                break;
            }
            case FULL_TRANSITIVE: {
                incompatibleDiffs = this.unionOf(this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)existing, (String)proposed, resolvedReferences)), this.transitively(existingArtifacts, proposedArtifactContent, (existing, proposed) -> this.isBackwardsCompatibleWith((String)proposed, (String)existing, resolvedReferences)));
                break;
            }
        }
        Set<CompatibilityDifference> diffs = incompatibleDiffs.stream().map(this::transform).collect(Collectors.toSet());
        return CompatibilityExecutionResult.incompatibleOrEmpty(diffs);
    }

    private Set<D> transitively(List<TypedContent> existingSchemas, String proposedSchema, BiFunction<String, String, Set<D>> checkExistingProposed) {
        HashSet<D> result = new HashSet<D>();
        for (int i = existingSchemas.size() - 1; i >= 0; --i) {
            Set<D> current = checkExistingProposed.apply(existingSchemas.get(i).getContent().content(), proposedSchema);
            result.addAll(current);
        }
        return result;
    }

    protected abstract Set<D> isBackwardsCompatibleWith(String var1, String var2, Map<String, TypedContent> var3);

    protected abstract CompatibilityDifference transform(D var1);

    private Set<D> unionOf(Set<D> ... from) {
        HashSet<D> rval = new HashSet<D>();
        for (Set<D> f : from) {
            rval.addAll(f);
        }
        return rval;
    }
}

