/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import java.io.IOException;

public class JsonContentCanonicalizer
implements ContentCanonicalizer {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);

    public ContentHandle canonicalize(ContentHandle content) {
        try {
            JsonNode root = this.readAsJsonNode(content);
            this.processJsonNode(root);
            String converted = this.mapper.writeValueAsString(this.mapper.treeToValue((TreeNode)root, Object.class));
            return ContentHandle.create((String)converted);
        }
        catch (Throwable t) {
            return content;
        }
    }

    protected void processJsonNode(JsonNode node) {
    }

    private JsonNode readAsJsonNode(ContentHandle content) throws IOException {
        return this.mapper.readTree(content.content());
    }
}

