/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;

public class JsonSchemaContentValidator
implements ContentValidator {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public void validate(ValidityLevel level, ContentHandle artifactContent) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                JsonNode node = objectMapper.readTree(artifactContent.bytes());
                if (level == ValidityLevel.FULL) {
                    JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
                    factory.getSchema(node);
                }
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for JSON Schema artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
    }
}

