/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonUtil;
import java.io.IOException;
import java.util.Map;

public class JsonSchemaDereferencer
implements ContentDereferencer {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ContentHandle dereference(ContentHandle content, Map<String, ContentHandle> resolvedReferences) {
        try {
            return ContentHandle.create((String)JsonUtil.readSchema(content.content(), resolvedReferences).toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + content.content(), e);
        }
    }

    static {
        objectMapper.registerModule((Module)new ParameterNamesModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonOrgModule());
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }
}

