/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContentExtractor
implements ContentExtractor {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();

    public ExtractedMetaData extract(ContentHandle content) {
        try {
            JsonNode jsonSchema = this.mapper.readTree(content.bytes());
            JsonNode title = jsonSchema.get("title");
            JsonNode desc = jsonSchema.get("description");
            ExtractedMetaData metaData = null;
            if (title != null && !title.isNull()) {
                metaData = new ExtractedMetaData();
                metaData.setName(title.asText());
            }
            if (desc != null && !desc.isNull()) {
                if (metaData == null) {
                    metaData = new ExtractedMetaData();
                }
                metaData.setDescription(desc.asText());
            }
            return metaData;
        }
        catch (IOException e) {
            this.log.warn("Error extracting metadata from JSON: {}", (Object)e.getMessage());
            return null;
        }
    }
}

