/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.dereference.DereferencingNotSupportedException;
import java.util.Iterator;
import java.util.Map;

public class JsonSchemaDereferencer
implements ContentDereferencer {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public TypedContent dereference(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        throw new DereferencingNotSupportedException("Content dereferencing is not supported for JSON Schema");
    }

    public TypedContent rewriteReferences(TypedContent content, Map<String, String> resolvedReferenceUrls) {
        try {
            JsonNode tree = objectMapper.readTree(content.getContent().content());
            this.rewriteIn(tree, resolvedReferenceUrls);
            String converted = objectMapper.writeValueAsString(objectMapper.treeToValue((TreeNode)tree, Object.class));
            return TypedContent.create((ContentHandle)ContentHandle.create((String)converted), (String)"application/json");
        }
        catch (Exception e) {
            return content;
        }
    }

    private void rewriteIn(JsonNode node, Map<String, String> resolvedReferenceUrls) {
        if (node.isObject()) {
            this.rewriteInObject((ObjectNode)node, resolvedReferenceUrls);
        }
    }

    private void rewriteInObject(ObjectNode node, Map<String, String> resolvedReferenceUrls) {
        String $ref;
        if (node.hasNonNull("$ref") && resolvedReferenceUrls.containsKey($ref = node.get("$ref").asText())) {
            node.put("$ref", resolvedReferenceUrls.get($ref));
        }
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldValue = node.get(fieldName);
            if (!fieldValue.isObject()) continue;
            this.rewriteInObject((ObjectNode)fieldValue, resolvedReferenceUrls);
        }
    }

    static {
        objectMapper.registerModule((Module)new ParameterNamesModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonOrgModule());
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }
}

