/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import java.io.IOException;
import java.util.Map;

public class JsonContentCanonicalizer
implements ContentCanonicalizer {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);

    public TypedContent canonicalize(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            JsonNode root = this.readAsJsonNode(content);
            this.processJsonNode(root);
            String converted = this.mapper.writeValueAsString(this.mapper.treeToValue((TreeNode)root, Object.class));
            return TypedContent.create((ContentHandle)ContentHandle.create((String)converted), (String)"application/json");
        }
        catch (Throwable t) {
            return content;
        }
    }

    protected void processJsonNode(JsonNode node) {
    }

    private JsonNode readAsJsonNode(TypedContent content) throws IOException {
        return this.mapper.readTree(content.getContent().content());
    }
}

