/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.Difference;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

public class JsonSchemaDiffLibrary {
    private static final String SCHEMA_KEYWORD = "$schema";

    public static DiffContext findDifferences(String original, String updated, Map<String, TypedContent> resolvedReferences) {
        try {
            JsonNode originalNode = JsonUtil.MAPPER.readTree(original);
            JsonNode updatedNode = JsonUtil.MAPPER.readTree(updated);
            JSONObject originalJson = (JSONObject)JsonUtil.MAPPER.readValue(original, JSONObject.class);
            JSONObject updatedJson = (JSONObject)JsonUtil.MAPPER.readValue(updated, JSONObject.class);
            SchemaLoader.SchemaLoaderBuilder originalSchemaBuilder = SchemaLoader.builder();
            JsonSchemaDiffLibrary.loadReferences(originalNode, resolvedReferences, originalSchemaBuilder);
            Schema originalSchema = originalSchemaBuilder.schemaJson(originalJson).build().load().build();
            SchemaLoader.SchemaLoaderBuilder updatedSchemaBuilder = SchemaLoader.builder();
            JsonSchemaDiffLibrary.loadReferences(updatedNode, resolvedReferences, updatedSchemaBuilder);
            Schema updatedSchema = updatedSchemaBuilder.schemaJson(updatedJson).build().load().build();
            return JsonSchemaDiffLibrary.findDifferences(originalSchema, updatedSchema);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void loadReferences(JsonNode jsonNode, Map<String, TypedContent> resolvedReferences, SchemaLoader.SchemaLoaderBuilder schemaLoaderBuilder) {
        String id;
        String schema;
        SpecificationVersion spec = SpecificationVersion.DRAFT_7;
        if (jsonNode.has(SCHEMA_KEYWORD) && (schema = jsonNode.get(SCHEMA_KEYWORD).asText()) != null) {
            spec = SpecificationVersion.lookupByMetaSchemaUrl((String)schema).orElse(SpecificationVersion.DRAFT_7);
        }
        URI idUri = null;
        if (jsonNode.has(spec.idKeyword()) && (id = jsonNode.get(spec.idKeyword()).asText()) != null) {
            idUri = ReferenceResolver.resolve((URI)null, (String)id);
        }
        for (Map.Entry<String, TypedContent> stringStringEntry : resolvedReferences.entrySet()) {
            URI child = ReferenceResolver.resolve((URI)idUri, (String)stringStringEntry.getKey());
            schemaLoaderBuilder.registerSchemaByURI(child, (Object)new JSONObject(stringStringEntry.getValue().getContent().content()));
        }
    }

    public static DiffContext findDifferences(Schema originalSchema, Schema updatedSchema) {
        DiffContext rootContext = DiffContext.createRootContext();
        new SchemaDiffVisitor(rootContext, originalSchema).visit(WrapUtil.wrap(updatedSchema));
        return rootContext;
    }

    public static boolean isCompatible(String original, String updated, Map<String, TypedContent> resolvedReferences) {
        return JsonSchemaDiffLibrary.findDifferences(original, updated, resolvedReferences).foundAllDifferencesAreCompatible();
    }

    public static Set<Difference> getIncompatibleDifferences(String original, String updated, Map<String, TypedContent> resolvedReferences) {
        return JsonSchemaDiffLibrary.findDifferences(original, updated, resolvedReferences).getIncompatibleDifferences();
    }
}

