/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.CombinedSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;

public class CombinedSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final CombinedSchema original;

    public CombinedSchemaDiffVisitor(DiffContext ctx, CombinedSchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitCombinedSchema(CombinedSchemaWrapper schema) {
        if (DiffUtil.diffObjectIdentity(this.ctx.sub("[criterion]"), this.original.getCriterion(), schema.getCriterion(), CombinedSchema.ANY_CRITERION, DiffType.UNDEFINED_UNUSED, DiffType.UNDEFINED_UNUSED, DiffType.COMBINED_TYPE_CRITERION_EXTENDED, DiffType.COMBINED_TYPE_CRITERION_NARROWED, DiffType.COMBINED_TYPE_CRITERION_CHANGED)) {
            super.visitCombinedSchema(schema);
        }
    }

    @Override
    public void visitOneOfCombinedSchema(CombinedSchemaWrapper schema) {
        this.processSubschemas(schema, DiffType.COMBINED_TYPE_ONE_OF_SIZE_INCREASED, DiffType.COMBINED_TYPE_ONE_OF_SIZE_DECREASED);
        super.visitOneOfCombinedSchema(schema);
    }

    @Override
    public void visitAnyOfCombinedSchema(CombinedSchemaWrapper schema) {
        this.processSubschemas(schema, DiffType.COMBINED_TYPE_ANY_OF_SIZE_INCREASED, DiffType.COMBINED_TYPE_ANY_OF_SIZE_DECREASED);
        super.visitAnyOfCombinedSchema(schema);
    }

    @Override
    public void visitAllOfCombinedSchema(CombinedSchemaWrapper schema) {
        this.processSubschemas(schema, DiffType.COMBINED_TYPE_ALL_OF_SIZE_INCREASED, DiffType.COMBINED_TYPE_ALL_OF_SIZE_DECREASED);
        super.visitAllOfCombinedSchema(schema);
    }

    private void processSubschemas(CombinedSchemaWrapper schema, DiffType sizeIncreased, DiffType sizeDecreased) {
        ArrayList originalSubschemas = new ArrayList(this.original.getSubschemas());
        LinkedList<SchemaWrapper> updatedSubschemas = new LinkedList<SchemaWrapper>(schema.getSubschemas());
        HashMap compatibilityMap = new HashMap();
        DiffUtil.diffInteger(this.ctx.sub("[size]"), originalSubschemas.size(), updatedSubschemas.size(), DiffType.UNDEFINED_UNUSED, DiffType.UNDEFINED_UNUSED, sizeIncreased, sizeDecreased);
        if (originalSubschemas.size() <= updatedSubschemas.size()) {
            for (Schema o : originalSubschemas) {
                DiffContext rootCtx = null;
                if (!compatibilityMap.containsKey(WrapUtil.equalityWrap(o))) {
                    compatibilityMap.put(WrapUtil.equalityWrap(o), new HashSet());
                }
                for (SchemaWrapper u : updatedSubschemas) {
                    rootCtx = DiffContext.createRootContext("", this.ctx.visited);
                    new SchemaDiffVisitor(rootCtx, o).visit(u);
                    if (!rootCtx.foundAllDifferencesAreCompatible()) continue;
                    ((Set)compatibilityMap.get(WrapUtil.equalityWrap(o))).add(u);
                }
            }
            Optional<Map.Entry> first = compatibilityMap.entrySet().stream().min(Comparator.comparingInt(a -> ((Set)a.getValue()).size()));
            while (first.isPresent()) {
                Optional val = ((Set)first.get().getValue()).stream().findAny();
                if (val.isPresent()) {
                    compatibilityMap.values().forEach(s -> s.remove(val.get()));
                } else {
                    this.ctx.addDifference(DiffType.COMBINED_TYPE_SUBSCHEMA_NOT_COMPATIBLE, first.get().getKey(), null);
                }
                if (((Set)first.get().getValue()).isEmpty()) {
                    compatibilityMap.remove(first.get().getKey());
                }
                first = compatibilityMap.entrySet().stream().min(Comparator.comparingInt(a -> ((Set)a.getValue()).size()));
            }
        }
    }
}

