/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.json.JsonConverter;

public class KafkaConnectContentValidator
implements ContentValidator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JsonConverter jsonConverter = new JsonConverter();

    public void validate(ValidityLevel level, ContentHandle artifactContent, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                JsonNode jsonNode = mapper.readTree(artifactContent.content());
                jsonConverter.asConnectSchema(jsonNode);
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for Kafka Connect Schema artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
    }

    public void validateReferences(ContentHandle artifactContent, List<ArtifactReference> references) throws RuleViolationException {
    }

    static {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("converter.type", "key");
        configs.put("schemas.cache.size", 0);
        jsonConverter.configure(configs);
    }
}

