/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.datamodels.refs.IReferenceResolver;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.dereference.ReferenceRewriter;
import io.apicurio.registry.content.dereference.RegistryReferenceResolver;
import io.apicurio.registry.content.util.ContentTypeUtil;
import java.io.IOException;
import java.util.Map;

public class ApicurioDataModelsContentDereferencer
implements ContentDereferencer {
    public TypedContent dereference(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            JsonNode node = ContentTypeUtil.parseJsonOrYaml((TypedContent)content);
            Document document = Library.readDocument((ObjectNode)((ObjectNode)node));
            RegistryReferenceResolver resolver = new RegistryReferenceResolver(resolvedReferences);
            Document dereferencedDoc = Library.dereferenceDocument((Document)document, (IReferenceResolver)resolver, (boolean)false);
            String dereferencedContentStr = Library.writeDocumentToJSONString((Document)dereferencedDoc);
            return TypedContent.create((ContentHandle)ContentHandle.create((String)dereferencedContentStr), (String)"application/json");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypedContent rewriteReferences(TypedContent content, Map<String, String> resolvedReferenceUrls) {
        try {
            JsonNode node = ContentTypeUtil.parseJsonOrYaml((TypedContent)content);
            Document doc = Library.readDocument((ObjectNode)((ObjectNode)node));
            ReferenceRewriter visitor = new ReferenceRewriter(resolvedReferenceUrls);
            Library.visitTree((Node)doc, (Visitor)visitor, (TraverserDirection)TraverserDirection.down);
            return TypedContent.create((ContentHandle)ContentHandle.create((String)Library.writeDocumentToJSONString((Document)doc)), (String)"application/json");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

