/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceInliner
extends AllNodeVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceInliner.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, TypedContent> resolvedReferences;

    public ReferenceInliner(Map<String, TypedContent> resolvedReferences) {
        this.resolvedReferences = resolvedReferences;
    }

    protected void visitNode(Node node) {
        String $ref;
        if (node instanceof Referenceable && ($ref = ((Referenceable)node).get$ref()) != null && this.resolvedReferences.containsKey($ref)) {
            this.inlineRef((Referenceable)node);
        }
    }

    private void inlineRef(Referenceable refNode) {
        String $ref = refNode.get$ref();
        JsonPointerExternalReference refPointer = new JsonPointerExternalReference($ref);
        ContentHandle refContent = this.resolvedReferences.get($ref).getContent();
        ObjectNode refContentNode = this.getRefNodeFromContent(refContent, refPointer.getComponent());
        if (refContentNode != null) {
            Library.readNode((ObjectNode)refContentNode, (Node)((Node)refNode));
            refNode.set$ref(null);
        }
    }

    private ObjectNode getRefNodeFromContent(ContentHandle refContent, String refComponent) {
        block4: {
            try {
                ObjectNode refContentRootNode = (ObjectNode)mapper.readTree(refContent.content());
                if (refComponent != null) {
                    JsonPointer pointer = JsonPointer.compile((String)refComponent.substring(1));
                    JsonNode nodePointedTo = refContentRootNode.at(pointer);
                    if (!nodePointedTo.isMissingNode() && nodePointedTo.isObject()) {
                        return (ObjectNode)nodePointedTo;
                    }
                    break block4;
                }
                return refContentRootNode;
            }
            catch (Exception e) {
                logger.error("Failed to get referenced node from $ref content.", (Throwable)e);
            }
        }
        return null;
    }
}

