/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.refs.LocalReferenceResolver;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.apicurio.registry.content.util.ContentTypeUtil;
import java.io.IOException;
import java.util.Map;

public class RegistryReferenceResolver
extends LocalReferenceResolver {
    private final Map<String, TypedContent> resolvedReferences;

    public RegistryReferenceResolver(Map<String, TypedContent> resolvedReferences) {
        this.resolvedReferences = resolvedReferences;
    }

    public Node resolveRef(String reference, Node from) {
        try {
            if (this.resolvedReferences.containsKey(reference)) {
                TypedContent resolvedRefContent = this.resolvedReferences.get(reference);
                JsonNode node = ContentTypeUtil.parseJsonOrYaml((TypedContent)resolvedRefContent);
                Document resolvedRefDoc = Library.readDocument((ObjectNode)((ObjectNode)node));
                JsonPointerExternalReference ref = new JsonPointerExternalReference(reference);
                return super.resolveRef(ref.getComponent(), (Node)resolvedRefDoc);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

