/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.util.ContentTypeUtil;
import java.util.Map;

public class OpenApiContentCanonicalizer
implements ContentCanonicalizer {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);

    public TypedContent canonicalize(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            JsonNode root = ContentTypeUtil.parseJsonOrYaml((TypedContent)content);
            String converted = this.mapper.writeValueAsString(this.mapper.treeToValue((TreeNode)root, Object.class));
            return TypedContent.create((ContentHandle)ContentHandle.create((String)converted), (String)"application/json");
        }
        catch (Throwable t) {
            return content;
        }
    }
}

