/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Message;
import io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Message;
import io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Message;
import io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Message;
import io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Message;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Message;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Message;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import java.util.Map;

public class ReferenceRewriter
extends AllNodeVisitor {
    private final Map<String, String> referenceUrls;

    public ReferenceRewriter(Map<String, String> referenceUrls) {
        this.referenceUrls = referenceUrls;
    }

    protected void visitNode(Node node) {
        String $ref;
        if (node instanceof Referenceable && ($ref = ((Referenceable)node).get$ref()) != null && this.referenceUrls.containsKey($ref)) {
            ((Referenceable)node).set$ref(this.referenceUrls.get($ref));
        }
    }

    public void visitMessage(AsyncApiMessage node) {
        String $ref;
        super.visitMessage(node);
        JsonNode payload = this.getPayload(node);
        if (payload != null && payload.hasNonNull("$ref") && this.referenceUrls.containsKey($ref = payload.get("$ref").asText())) {
            ((ObjectNode)payload).put("$ref", this.referenceUrls.get($ref));
        }
    }

    private JsonNode getPayload(AsyncApiMessage node) {
        if (node instanceof AsyncApi20Message) {
            return ((AsyncApi20Message)node).getPayload();
        }
        if (node instanceof AsyncApi21Message) {
            return ((AsyncApi21Message)node).getPayload();
        }
        if (node instanceof AsyncApi22Message) {
            return ((AsyncApi22Message)node).getPayload();
        }
        if (node instanceof AsyncApi23Message) {
            return ((AsyncApi23Message)node).getPayload();
        }
        if (node instanceof AsyncApi24Message) {
            return ((AsyncApi24Message)node).getPayload();
        }
        if (node instanceof AsyncApi25Message) {
            return ((AsyncApi25Message)node).getPayload();
        }
        if (node instanceof AsyncApi26Message) {
            return ((AsyncApi26Message)node).getPayload();
        }
        return null;
    }
}

