/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.google.protobuf.Descriptors;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProtobufContentValidator
implements ContentValidator {
    public void validate(ValidityLevel level, TypedContent content, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                if (resolvedReferences == null || resolvedReferences.isEmpty()) {
                    ProtobufFile.toProtoFileElement((String)content.getContent().content());
                } else {
                    ProtoFileElement protoFileElement = ProtobufFile.toProtoFileElement((String)content.getContent().content());
                    Map<String, ProtoFileElement> dependencies = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProtobufFile.toProtoFileElement((String)((TypedContent)e.getValue()).getContent().content()))));
                    MessageElement firstMessage = FileDescriptorUtils.firstMessage((ProtoFileElement)protoFileElement);
                    if (firstMessage != null) {
                        try {
                            Descriptors.Descriptor fileDescriptor = FileDescriptorUtils.toDescriptor((String)firstMessage.getName(), (ProtoFileElement)protoFileElement, dependencies);
                            TypedContent.create((ContentHandle)ContentHandle.create((String)fileDescriptor.toString()), (String)"application/x-protobuf");
                        }
                        catch (IllegalStateException ise) {
                            TypedContent.create((ContentHandle)ContentHandle.create((String)this.getFileDescriptorFromElement(protoFileElement).toString()), (String)"application/x-protobuf");
                        }
                    } else {
                        TypedContent.create((ContentHandle)ContentHandle.create((String)this.getFileDescriptorFromElement(protoFileElement).toString()), (String)"application/x-protobuf");
                    }
                }
            }
            catch (Exception e2) {
                throw new RuleViolationException("Syntax violation for Protobuf artifact.", RuleType.VALIDITY, level.name(), (Throwable)e2);
            }
        }
    }

    public void validateReferences(TypedContent content, List<ArtifactReference> references) throws RuleViolationException {
        try {
            Set mappedRefs = references.stream().map(ref -> ref.getName()).collect(Collectors.toSet());
            ProtoFileElement protoFileElement = ProtobufFile.toProtoFileElement((String)content.getContent().content());
            HashSet allImports = new HashSet();
            allImports.addAll(protoFileElement.getImports());
            allImports.addAll(protoFileElement.getPublicImports());
            Set violations = allImports.stream().filter(_import -> !mappedRefs.contains(_import)).map(missingRef -> new RuleViolation("Unmapped reference detected.", missingRef)).collect(Collectors.toSet());
            if (!violations.isEmpty()) {
                throw new RuleViolationException("Unmapped reference(s) detected.", RuleType.INTEGRITY, IntegrityLevel.ALL_REFS_MAPPED.name(), violations);
            }
        }
        catch (RuleViolationException rve) {
            throw rve;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ProtobufSchema getFileDescriptorFromElement(ProtoFileElement fileElem) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor fileDescriptor = FileDescriptorUtils.protoFileToFileDescriptor((ProtoFileElement)fileElem);
        return new ProtobufSchema(fileDescriptor, fileElem);
    }
}

