/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.google.protobuf.DescriptorProtos;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProtobufDereferencer
implements ContentDereferencer {
    public TypedContent dereference(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        ProtoFileElement protoFileElement = ProtobufFile.toProtoFileElement((String)content.getContent().content());
        Map<String, String> schemaDefs = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypedContent)e.getValue()).getContent().content())));
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = FileDescriptorUtils.toFileDescriptorProto((String)content.getContent().content(), (String)FileDescriptorUtils.firstMessage((ProtoFileElement)protoFileElement).getName(), Optional.ofNullable(protoFileElement.getPackageName()), schemaDefs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            fileDescriptorProto.writeTo((OutputStream)outputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return TypedContent.create((ContentHandle)ContentHandle.create((byte[])outputStream.toByteArray()), (String)"application/x-protobuf");
    }

    public TypedContent rewriteReferences(TypedContent content, Map<String, String> resolvedReferenceUrls) {
        return content;
    }
}

