/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.types.provider.AsyncApiArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.AvroArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.GraphQLArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.JsonArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.KConnectArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.OpenApiArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ProtobufArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.WsdlArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.XmlArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.XsdArtifactTypeUtilProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultArtifactTypeUtilProviderImpl
implements ArtifactTypeUtilProviderFactory {
    protected Map<String, ArtifactTypeUtilProvider> providerMap = new ConcurrentHashMap<String, ArtifactTypeUtilProvider>();
    protected List<ArtifactTypeUtilProvider> standardProviders = new ArrayList<XmlArtifactTypeUtilProvider>(List.of(new ProtobufArtifactTypeUtilProvider(), new OpenApiArtifactTypeUtilProvider(), new AsyncApiArtifactTypeUtilProvider(), new JsonArtifactTypeUtilProvider(), new AvroArtifactTypeUtilProvider(), new GraphQLArtifactTypeUtilProvider(), new KConnectArtifactTypeUtilProvider(), new WsdlArtifactTypeUtilProvider(), new XsdArtifactTypeUtilProvider(), new XmlArtifactTypeUtilProvider()));
    protected List<ArtifactTypeUtilProvider> providers = new ArrayList<ArtifactTypeUtilProvider>();

    public DefaultArtifactTypeUtilProviderImpl() {
    }

    public DefaultArtifactTypeUtilProviderImpl(boolean initStandardProviders) {
        if (initStandardProviders) {
            this.loadStandardProviders();
        }
    }

    protected void loadStandardProviders() {
        this.providers.addAll(this.standardProviders);
    }

    @Override
    public ArtifactTypeUtilProvider getArtifactTypeProvider(String type) {
        return this.providerMap.computeIfAbsent(type, t -> this.providers.stream().filter(a -> a.getArtifactType().equals(t)).findFirst().orElseThrow(() -> new IllegalStateException("No such artifact type provider: " + t)));
    }

    @Override
    public List<String> getAllArtifactTypes() {
        return this.providers.stream().map(a -> a.getArtifactType()).collect(Collectors.toList());
    }

    @Override
    public List<ArtifactTypeUtilProvider> getAllArtifactTypeProviders() {
        return this.providers;
    }
}

