/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.parser.XMLParserException;

public class XmlContentCanonicalizer
implements ContentCanonicalizer {
    private static ThreadLocal<Canonicalizer> xmlCanonicalizer = new ThreadLocal<Canonicalizer>(){

        @Override
        protected Canonicalizer initialValue() {
            try {
                return Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (InvalidCanonicalizerException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public TypedContent canonicalize(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            Canonicalizer canon = xmlCanonicalizer.get();
            ByteArrayOutputStream out = new ByteArrayOutputStream(content.getContent().getSizeBytes());
            canon.canonicalize(content.getContent().bytes(), (OutputStream)out, false);
            String canonicalized = out.toString(Canonicalizer.ENCODING);
            return TypedContent.create((ContentHandle)ContentHandle.create((String)canonicalized), (String)"application/xml");
        }
        catch (IOException | CanonicalizationException | XMLParserException throwable) {
            return content;
        }
    }

    static {
        Init.init();
    }
}

