/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.schema.validation.json;

import io.apicurio.schema.validation.json.ValidationError;
import java.util.List;

public class JsonValidationResult {
    protected static final JsonValidationResult SUCCESS = JsonValidationResult.successfull();
    private boolean success;
    private List<ValidationError> validationErrors;

    private JsonValidationResult(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        this.success = this.validationErrors == null || this.validationErrors.isEmpty();
    }

    public boolean success() {
        return this.success;
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public String toString() {
        if (this.success) {
            return "JsonValidationResult [ success ]";
        }
        return "JsonValidationResult [ errors = " + this.validationErrors.toString() + " ]";
    }

    public static JsonValidationResult fromErrors(List<ValidationError> errors) {
        return new JsonValidationResult(errors);
    }

    public static JsonValidationResult successfull() {
        return new JsonValidationResult(null);
    }
}

