/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.schema.validation.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.apicurio.registry.resolver.DefaultSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.schema.validation.json.ByteBufferInputStream;
import io.apicurio.schema.validation.json.JsonValidationResult;
import io.apicurio.schema.validation.json.ValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonValidator {
    private SchemaResolver<JsonSchema, Object> schemaResolver;
    private ArtifactReference artifactReference;
    static final ObjectMapper mapper = new ObjectMapper();

    public JsonValidator(Map<String, Object> configuration, Optional<ArtifactReference> artifactReference) {
        this.schemaResolver = new DefaultSchemaResolver();
        this.schemaResolver.configure(configuration, (SchemaParser)new JsonSchemaParser());
        artifactReference.ifPresent(reference -> {
            this.artifactReference = reference;
        });
    }

    protected JsonValidator() {
    }

    public JsonValidationResult validateByArtifactReference(Object bean) {
        Objects.requireNonNull(this.artifactReference, "ArtifactReference must be provided when creating JsonValidator in order to use this feature");
        SchemaLookupResult schema = this.schemaResolver.resolveSchemaByArtifactReference(this.artifactReference);
        JsonNode jsonPayload = this.createJSONObject(bean);
        return this.validate((JsonSchema)schema.getParsedSchema().getParsedSchema(), jsonPayload);
    }

    public JsonValidationResult validate(Record<Object> record) {
        SchemaLookupResult schema = this.schemaResolver.resolveSchema(record);
        JsonNode jsonPayload = this.createJSONObject(record.payload());
        return this.validate((JsonSchema)schema.getParsedSchema().getParsedSchema(), jsonPayload);
    }

    protected JsonValidationResult validate(JsonSchema schema, JsonNode jsonPayload) {
        Set validate = schema.validate(jsonPayload);
        if (!validate.isEmpty()) {
            return JsonValidationResult.fromErrors(this.extractValidationErrors(validate));
        }
        return JsonValidationResult.SUCCESS;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonNode createJSONObject(Object bean) {
        if (bean instanceof ByteBuffer) {
            try (ByteBufferInputStream inputStream = new ByteBufferInputStream((ByteBuffer)bean);){
                JsonNode jsonNode;
                block14: {
                    JsonParser parser = mapper.getFactory().createParser((InputStream)inputStream);
                    try {
                        jsonNode = (JsonNode)parser.readValueAs(JsonNode.class);
                        if (parser == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return jsonNode;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return (JsonNode)mapper.convertValue(bean, JsonNode.class);
    }

    private List<ValidationError> extractValidationErrors(Set<ValidationMessage> validationErrors) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            for (ValidationMessage cause : validationErrors) {
                ValidationError error = new ValidationError(cause.getMessage(), cause.getCode());
                errors.add(error);
            }
        }
        return errors;
    }

    public static class JsonSchemaParser
    implements SchemaParser<JsonSchema, Object> {
        public String artifactType() {
            return "JSON";
        }

        public JsonSchema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<JsonSchema>> resolvedReferences) {
            HashMap<String, String> referenceSchemas = new HashMap<String, String>();
            this.resolveReferences(resolvedReferences, referenceSchemas);
            JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7, builder -> builder.schemaLoaders(schemaLoaders -> schemaLoaders.schemas(referenceSchemas)));
            return schemaFactory.getSchema(IoUtil.toString((byte[])rawSchema));
        }

        private void resolveReferences(Map<String, ParsedSchema<JsonSchema>> resolvedReferences, Map<String, String> referenceSchemas) {
            resolvedReferences.forEach((referenceName, schema) -> {
                if (schema.hasReferences()) {
                    this.resolveReferences(schema.getSchemaReferences().stream().collect(Collectors.toMap(parsedSchema -> ((JsonSchema)parsedSchema.getParsedSchema()).getId(), parsedSchema -> parsedSchema)), referenceSchemas);
                }
                referenceSchemas.put(((JsonSchema)schema.getParsedSchema()).getId(), IoUtil.toString((byte[])schema.getRawSchema()));
            });
        }

        public ParsedSchema<JsonSchema> getSchemaFromData(Record<Object> data) {
            return null;
        }

        public ParsedSchema<JsonSchema> getSchemaFromData(Record<Object> record, boolean dereference) {
            return null;
        }

        public boolean supportsExtractSchemaFromData() {
            return false;
        }
    }
}

