/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.schema.validation.protobuf;

import com.google.protobuf.Message;
import io.apicurio.registry.protobuf.ProtobufDifference;
import io.apicurio.registry.resolver.DefaultSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.rules.compatibility.protobuf.ProtobufCompatibilityCheckerLibrary;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import io.apicurio.schema.validation.protobuf.ProtobufRecord;
import io.apicurio.schema.validation.protobuf.ProtobufSchemaParser;
import io.apicurio.schema.validation.protobuf.ProtobufValidationResult;
import io.apicurio.schema.validation.protobuf.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProtobufValidator {
    private final ProtobufSchemaParser<Message> protobufSchemaUSchemaParser;
    private SchemaResolver<ProtobufSchema, Message> schemaResolver;
    private ArtifactReference artifactReference;

    public ProtobufValidator(Map<String, Object> configuration, Optional<ArtifactReference> artifactReference) {
        this.schemaResolver = new DefaultSchemaResolver();
        this.protobufSchemaUSchemaParser = new ProtobufSchemaParser();
        this.schemaResolver.configure(configuration, this.protobufSchemaUSchemaParser);
        artifactReference.ifPresent(reference -> {
            this.artifactReference = reference;
        });
    }

    protected ProtobufValidator() {
        this.protobufSchemaUSchemaParser = new ProtobufSchemaParser();
    }

    public ProtobufValidationResult validateByArtifactReference(Message bean) {
        Objects.requireNonNull(this.artifactReference, "ArtifactReference must be provided when creating JsonValidator in order to use this feature");
        SchemaLookupResult schema = this.schemaResolver.resolveSchemaByArtifactReference(this.artifactReference);
        return this.validate((ParsedSchema<ProtobufSchema>)schema.getParsedSchema(), new ProtobufRecord(bean, null));
    }

    public ProtobufValidationResult validate(Record<Message> record) {
        SchemaLookupResult schema = this.schemaResolver.resolveSchema(record);
        return this.validate((ParsedSchema<ProtobufSchema>)schema.getParsedSchema(), record);
    }

    protected ProtobufValidationResult validate(ParsedSchema<ProtobufSchema> schema, Record<Message> record) {
        if (schema.getParsedSchema() != null && ((ProtobufSchema)schema.getParsedSchema()).getFileDescriptor().findMessageTypeByName(((Message)record.payload()).getDescriptorForType().getName()) == null) {
            return ProtobufValidationResult.fromErrors(List.of(new ValidationError("Missing message type " + ((Message)record.payload()).getDescriptorForType().getName() + " in the protobuf schema", "")));
        }
        List<ProtobufDifference> diffs = this.validate(schema, (Message)record.payload());
        if (!diffs.isEmpty()) {
            ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
            diffs.forEach(diff -> validationErrors.add(new ValidationError(diff.getMessage(), "")));
            return ProtobufValidationResult.fromErrors(validationErrors);
        }
        return ProtobufValidationResult.SUCCESS;
    }

    private List<ProtobufDifference> validate(ParsedSchema<ProtobufSchema> schemaFromRegistry, Message data) {
        ProtobufFile fileBefore = ((ProtobufSchema)schemaFromRegistry.getParsedSchema()).getProtobufFile();
        ProtobufFile fileAfter = new ProtobufFile(this.protobufSchemaUSchemaParser.toProtoFileElement(data.getDescriptorForType().getFile()));
        ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
        return checker.findDifferences();
    }
}

