/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client;

import io.apicurio.registry.search.client.SearchClientFactory;
import io.apicurio.registry.search.client.SearchResponse;
import io.apicurio.registry.search.client.SearchResults;
import io.apicurio.registry.search.common.Search;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public interface SearchClient
extends AutoCloseable {
    public static final BiFunction<SearchResponse, SearchResponse, SearchResponse> SRFN = (sr1, sr2) -> sr2;

    public static SearchClient create(Properties properties) {
        return SearchClientFactory.create(properties);
    }

    public CompletionStage<Boolean> initialize(boolean var1) throws Exception;

    public CompletionStage<SearchResponse> index(Search.Artifact var1) throws Exception;

    default public CompletionStage<SearchResponse> index(List<Search.Artifact> artifacts) throws Exception {
        if (artifacts == null || artifacts.size() == 0) {
            throw new IllegalArgumentException("Empty artifacts!");
        }
        CompletionStage<SearchResponse> cs = this.index(artifacts.get(0));
        for (int i = 1; i < artifacts.size(); ++i) {
            cs = cs.thenCombine(this.index(artifacts.get(i)), SRFN);
        }
        return cs;
    }

    public CompletionStage<SearchResults> search(String var1);
}

