/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.search.client.hotrod;

import io.apicurio.registry.search.client.SearchResponse;
import io.apicurio.registry.search.client.SearchResults;
import io.apicurio.registry.search.client.SearchUtil;
import io.apicurio.registry.search.client.common.InfinispanSearchClient;
import io.apicurio.registry.search.client.hotrod.ArtifactMarshaller;
import io.apicurio.registry.search.client.hotrod.ArtifactTypeMarshaller;
import io.apicurio.registry.search.client.hotrod.HotRodSearchResponse;
import io.apicurio.registry.search.client.hotrod.HotRodSearchResults;
import io.apicurio.registry.search.common.Search;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public class HotRodSearchClient
extends InfinispanSearchClient {
    private RemoteCacheManager manager;
    private RemoteCache<String, Search.Artifact> cache;

    public HotRodSearchClient(Properties properties) {
        super(properties);
    }

    private RemoteCache<String, Search.Artifact> getCache() {
        if (this.cache == null) {
            this.cache = this.manager.getCache(this.cacheName);
        }
        return this.cache;
    }

    @Override
    protected int defaultPort() {
        return 11222;
    }

    @Override
    protected void initialize(Properties properties, String host, int port, String username, String password, String cacheName) {
        String realm = SearchUtil.property(properties, "search.realm", "default");
        String serverName = SearchUtil.property(properties, "search.server-name", "infinispan");
        ClientIntelligence ci = ClientIntelligence.valueOf((String)SearchUtil.property(properties, "search.client-intelligence", "BASIC"));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(host).port(port).security().authentication().username(username).password(password).realm(realm).serverName(serverName).clientIntelligence(ci).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.manager = new RemoteCacheManager(clientBuilder.build());
    }

    private void registerProto(boolean reset, String ... protoKeys) {
        RemoteCache cache = this.manager.getCache("___protobuf_metadata");
        if (cache == null) {
            throw new IllegalStateException(String.format("Missing %s cache!", "___protobuf_metadata"));
        }
        SerializationContext ctx = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.manager);
        FileDescriptorSource fds = new FileDescriptorSource();
        for (String protoKey : protoKeys) {
            if (!reset && cache.containsKey((Object)protoKey)) continue;
            String protoContent = IoUtil.toString((InputStream)this.getClass().getResourceAsStream("/" + protoKey));
            this.log.info(String.format("Using proto schema: %s%n%s", protoKey, protoContent));
            fds.addProtoFile(protoKey, protoContent);
            cache.put((Object)protoKey, (Object)protoContent);
        }
        ctx.registerProtoFiles(fds);
        ctx.registerMarshaller((BaseMarshaller)new ArtifactTypeMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new ArtifactMarshaller());
    }

    @Override
    public CompletionStage<Boolean> initialize(boolean reset) {
        this.registerProto(reset, "common.proto", "search.proto");
        Set caches = this.manager.getCacheNames();
        boolean hasSearch = caches.contains(this.cacheName);
        if (reset || !hasSearch) {
            if (hasSearch) {
                this.manager.administration().removeCache(this.cacheName);
            }
            String xml = String.format("<infinispan>\n    <cache-container>\n        <distributed-cache name=\"%s\" mode=\"ASYNC\">\n            <indexing index=\"LOCAL\" auto-config=\"true\">\n            </indexing>\n        </distributed-cache>\n    </cache-container>\n</infinispan>", this.cacheName);
            XMLStringConfiguration configuration = new XMLStringConfiguration(xml);
            this.cache = this.manager.administration().createCache(this.cacheName, (BasicConfiguration)configuration);
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    public CompletionStage<SearchResponse> index(Search.Artifact artifact) {
        return this.getCache().putAsync((Object)this.toKey(artifact), (Object)artifact).thenApply(a -> HotRodSearchResponse.INSTANCE);
    }

    @Override
    public CompletionStage<SearchResponse> index(List<Search.Artifact> artifacts) {
        HashMap<String, Search.Artifact> data = new HashMap<String, Search.Artifact>();
        for (Search.Artifact artifact : artifacts) {
            data.put(this.toKey(artifact), artifact);
        }
        return this.getCache().putAllAsync(data).thenApply(a -> HotRodSearchResponse.INSTANCE);
    }

    @Override
    public CompletionStage<SearchResults> search(String query) {
        QueryFactory qf = Search.getQueryFactory(this.getCache());
        query = query.replace("$Artifact", HotRodSearchClient.toFqn());
        Query q = qf.create(query);
        List list = q.execute().list();
        return CompletableFuture.completedFuture(new HotRodSearchResults(list));
    }

    @Override
    public void close() {
        IoUtil.closeIgnore((AutoCloseable)this.manager);
    }
}

