/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaSerDe;
import io.apicurio.registry.serde.LazyLoadedParsedSchema;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.ParsedSchemaImpl;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.strategy.ArtifactResolverStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public abstract class AbstractKafkaSerializer<T, U>
extends AbstractKafkaSerDe<T, U>
implements Serializer<U> {
    public AbstractKafkaSerializer() {
    }

    public AbstractKafkaSerializer(RegistryClient client) {
        super(client);
    }

    public AbstractKafkaSerializer(SchemaResolver<T, U> schemaResolver) {
        super(schemaResolver);
    }

    public AbstractKafkaSerializer(RegistryClient client, ArtifactResolverStrategy<T> artifactResolverStrategy, SchemaResolver<T, U> schemaResolver) {
        super(client, schemaResolver);
        this.getSchemaResolver().setArtifactResolverStrategy(artifactResolverStrategy);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(new BaseKafkaSerDeConfig(configs), isKey);
    }

    protected ParsedSchema<T> getSchemaFromData(U data) {
        return null;
    }

    protected abstract void serializeData(ParsedSchema<T> var1, U var2, OutputStream var3) throws IOException;

    protected abstract void serializeData(Headers var1, ParsedSchema<T> var2, U var3, OutputStream var4) throws IOException;

    public byte[] serialize(String topic, U data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, U data) {
        if (data == null) {
            return null;
        }
        try {
            LazyLoadedParsedSchema schemaFromData = new LazyLoadedParsedSchema(() -> Optional.ofNullable(this.getSchemaFromData(data)));
            SchemaLookupResult schema = this.getSchemaResolver().resolveSchema(topic, headers, data, schemaFromData);
            ParsedSchemaImpl parsedSchema = new ParsedSchemaImpl().setRawSchema(schema.getRawSchema()).setParsedSchema(schema.getSchema());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.headersHandler != null && headers != null) {
                this.headersHandler.writeHeaders(headers, schema.toArtifactReference());
                this.serializeData(headers, parsedSchema, data, out);
            } else {
                out.write(0);
                this.getIdHandler().writeId(schema.toArtifactReference(), out);
                this.serializeData(parsedSchema, data, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

