/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.auth.Auth;
import io.apicurio.registry.auth.BasicAuth;
import io.apicurio.registry.auth.KeycloakAuth;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.serde.CheckPeriodCache;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.config.DefaultSchemaResolverConfig;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import io.apicurio.registry.serde.strategy.ArtifactResolverStrategy;
import io.apicurio.registry.serde.utils.Utils;
import io.apicurio.registry.utils.IoUtil;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractSchemaResolver<S, T>
implements SchemaResolver<S, T> {
    protected final Map<Long, SchemaLookupResult<S>> schemaCacheByGlobalId = new ConcurrentHashMap<Long, SchemaLookupResult<S>>();
    protected final Map<String, Long> globalIdCacheByContent = new ConcurrentHashMap<String, Long>();
    protected CheckPeriodCache<ArtifactReference, Long> globalIdCacheByArtifactReference = new CheckPeriodCache(0L);
    protected SchemaParser<S> schemaParser;
    protected RegistryClient client;
    protected boolean isKey;
    protected ArtifactResolverStrategy<S> artifactResolverStrategy;
    protected String explicitArtifactGroupId;
    protected String explicitArtifactId;
    protected String explicitArtifactVersion;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey, SchemaParser<S> schemaParser) {
        this.schemaParser = schemaParser;
        this.isKey = isKey;
        DefaultSchemaResolverConfig config = new DefaultSchemaResolverConfig(configs);
        if (this.client == null) {
            String baseUrl = config.getRegistryUrl();
            if (baseUrl == null) {
                throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
            }
            String authServerURL = config.getAuthServiceUrl();
            try {
                String username;
                this.client = authServerURL != null ? this.configureClientWithBearerAuthentication(config, baseUrl, authServerURL) : ((username = config.getAuthUsername()) != null ? this.configureClientWithBasicAuth(config, username, baseUrl) : RegistryClientFactory.create((String)baseUrl, (Map)config.originals()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        Object ais = config.getArtifactResolverStrategy();
        Utils.instantiate(ArtifactResolverStrategy.class, ais, this::setArtifactResolverStrategy);
        long checkPeriod = 0L;
        Object cp = config.getCheckPeriodMs();
        if (cp != null) {
            long checkPeriodParam;
            if (cp instanceof Number) {
                checkPeriodParam = ((Number)cp).longValue();
            } else if (cp instanceof String) {
                checkPeriodParam = Long.parseLong((String)cp);
            } else if (cp instanceof Duration) {
                checkPeriodParam = ((Duration)cp).toMillis();
            } else {
                throw new IllegalArgumentException("Check period config param type unsupported (must be a Number, String, or Duration): " + cp);
            }
            if (checkPeriodParam < 0L) {
                throw new IllegalArgumentException("Check period must be non-negative: " + checkPeriodParam);
            }
            checkPeriod = checkPeriodParam;
        }
        this.globalIdCacheByArtifactReference = new CheckPeriodCache(checkPeriod);
        String groupIdOverride = config.getExplicitArtifactGroupId();
        if (groupIdOverride != null) {
            this.explicitArtifactGroupId = groupIdOverride;
        }
        String artifactIdOverride = config.getExplicitArtifactId();
        if (groupIdOverride != null) {
            this.explicitArtifactId = artifactIdOverride;
        }
        String artifactVersionOverride = config.getExplicitArtifactVersion();
        if (groupIdOverride != null) {
            this.explicitArtifactVersion = artifactVersionOverride;
        }
    }

    @Override
    public void setClient(RegistryClient client) {
        this.client = client;
    }

    @Override
    public void setArtifactResolverStrategy(ArtifactResolverStrategy<S> artifactResolverStrategy) {
        this.artifactResolverStrategy = artifactResolverStrategy;
    }

    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    protected ArtifactReference resolveArtifactReference(String topic, Headers headers, T data, ParsedSchema<S> parsedSchema) {
        Object schema = null;
        if (this.artifactResolverStrategy.loadSchema() && parsedSchema != null) {
            schema = parsedSchema.getParsedSchema();
        }
        ArtifactReference artifactReference = this.artifactResolverStrategy.artifactReference(topic, this.isKey, schema);
        artifactReference = ArtifactReference.builder().groupId(this.explicitArtifactGroupId == null ? artifactReference.getGroupId() : this.explicitArtifactGroupId).artifactId(this.explicitArtifactId == null ? artifactReference.getArtifactId() : this.explicitArtifactId).version(this.explicitArtifactVersion == null ? artifactReference.getVersion() : this.explicitArtifactVersion).build();
        return artifactReference;
    }

    protected SchemaLookupResult<S> resolveSchemaByGlobalId(long globalId) {
        return this.schemaCacheByGlobalId.computeIfAbsent(globalId, k -> {
            InputStream rawSchema = this.client.getContentByGlobalId(globalId);
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            S parsed = this.schemaParser.parseSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.globalId(globalId).rawSchema(schema).schema(parsed).build();
        });
    }

    @Override
    public void reset() {
        this.schemaCacheByGlobalId.clear();
        this.globalIdCacheByContent.clear();
        this.globalIdCacheByArtifactReference.clear();
    }

    private RegistryClient configureClientWithBearerAuthentication(DefaultSchemaResolverConfig config, String registryUrl, String authServerUrl) {
        String realm = config.getAuthRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Missing registry auth realm, set apicurio.auth.realm");
        }
        String clientId = config.getAuthClientId();
        if (clientId == null) {
            throw new IllegalArgumentException("Missing registry auth clientId, set apicurio.auth.client.id");
        }
        String clientSecret = config.getAuthClientSecret();
        if (clientSecret == null) {
            throw new IllegalArgumentException("Missing registry auth secret, set apicurio.auth.client.secret");
        }
        KeycloakAuth auth = new KeycloakAuth(authServerUrl, realm, clientId, clientSecret);
        return RegistryClientFactory.create((String)registryUrl, (Map)config.originals(), (Auth)auth);
    }

    private RegistryClient configureClientWithBasicAuth(DefaultSchemaResolverConfig config, String registryUrl, String username) {
        String password = config.getAuthPassword();
        if (password == null) {
            throw new IllegalArgumentException("Missing registry auth password, set apicurio.auth.password");
        }
        BasicAuth auth = new BasicAuth(username, password);
        return RegistryClientFactory.create((String)registryUrl, (Map)config.originals(), (Auth)auth);
    }

    protected void loadFromArtifactMetaData(ArtifactMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }

    protected void loadFromArtifactMetaData(VersionMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }
}

