/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.strategy;

public class ArtifactReference {
    private String groupId;
    private String artifactId;
    private String version;
    private Long globalId;
    private Long contentId;

    private ArtifactReference() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getGlobalId() {
        return this.globalId;
    }

    public Long getContentId() {
        return this.contentId;
    }

    private void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    private void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    private void setGlobalId(Long globalId) {
        this.globalId = globalId;
    }

    private void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.contentId == null ? 0 : this.contentId.hashCode());
        result = 31 * result + (this.globalId == null ? 0 : this.globalId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactReference other = (ArtifactReference)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.contentId == null ? other.contentId != null : !this.contentId.equals(other.contentId)) {
            return false;
        }
        if (this.globalId == null ? other.globalId != null : !this.globalId.equals(other.globalId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ArtifactReference [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", globalId=" + this.globalId + ", contentId=" + this.contentId + "]";
    }

    public static ArtifactReference fromGlobalId(Long globalId) {
        return ArtifactReference.builder().globalId(globalId).build();
    }

    public static ArtifactReferenceBuilder builder() {
        return new ArtifactReferenceBuilder();
    }

    public static class ArtifactReferenceBuilder {
        private ArtifactReference reference = new ArtifactReference();

        ArtifactReferenceBuilder() {
        }

        public ArtifactReferenceBuilder groupId(String groupId) {
            this.reference.setGroupId(groupId);
            return this;
        }

        public ArtifactReferenceBuilder artifactId(String artifactId) {
            this.reference.setArtifactId(artifactId);
            return this;
        }

        public ArtifactReferenceBuilder version(String version) {
            this.reference.setVersion(version);
            return this;
        }

        public ArtifactReferenceBuilder globalId(Long globalId) {
            this.reference.setGlobalId(globalId);
            return this;
        }

        public ArtifactReferenceBuilder contentId(Long contentId) {
            this.reference.setContentId(contentId);
            return this;
        }

        public ArtifactReference build() {
            return this.reference;
        }
    }
}

