/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.DefaultSchemaResolver;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.utils.Utils;
import java.util.Map;
import java.util.Objects;

public class SchemaResolverConfigurer<T, U> {
    protected SchemaResolver<T, U> schemaResolver;

    public SchemaResolverConfigurer() {
    }

    public SchemaResolverConfigurer(RegistryClient client) {
        this(client, new DefaultSchemaResolver());
    }

    public SchemaResolverConfigurer(SchemaResolver<T, U> schemaResolver) {
        this(null, schemaResolver);
    }

    public SchemaResolverConfigurer(RegistryClient client, SchemaResolver<T, U> schemaResolver) {
        this();
        this.setSchemaResolver(schemaResolver);
        this.getSchemaResolver().setClient(client);
    }

    protected SchemaResolver<T, U> getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaResolver<T, U> schemaResolver) {
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    protected void configure(Map<String, ?> configs, boolean isKey, SchemaParser<T> schemaParser) {
        if (this.schemaResolver == null) {
            Object sr = configs.get("apicurio.registry.schema-resolver");
            if (null == sr) {
                this.setSchemaResolver(new DefaultSchemaResolver());
            } else {
                Utils.instantiate(SchemaResolver.class, sr, this::setSchemaResolver);
            }
        }
        this.getSchemaResolver().configure(configs, isKey, schemaParser);
    }
}

