/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.config;

import io.apicurio.registry.serde.SerdeConfig;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;

public class DefaultSchemaResolverConfig
extends BaseKafkaSerDeConfig {
    public static ConfigDef configDef() {
        return new ConfigDef().define("apicurio.registry.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.service.token.endpoint", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.service.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.realm", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.client.id", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.client.secret", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.username", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.auth.password", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.registry.artifact-resolver-strategy", ConfigDef.Type.CLASS, (Object)SerdeConfig.ARTIFACT_RESOLVER_STRATEGY_DEFAULT, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.registry.auto-register", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.registry.auto-register.if-exists", ConfigDef.Type.STRING, (Object)SerdeConfig.AUTO_REGISTER_ARTIFACT_IF_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, "TODO docs").define("apicurio.registry.find-latest", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "TODO docs").define("apicurio.registry.check-period-ms", ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.MEDIUM, "TODO docs").define("apicurio.registry.retry-count", ConfigDef.Type.LONG, (Object)3L, ConfigDef.Importance.MEDIUM, "TODO docs").define("apicurio.registry.retry-backoff-ms", ConfigDef.Type.LONG, (Object)300L, ConfigDef.Importance.MEDIUM, "TODO docs").define("apicurio.registry.artifact.group-id", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "TODO docs").define("apicurio.registry.artifact.artifact-id", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "TODO docs");
    }

    public DefaultSchemaResolverConfig(Map<?, ?> originals) {
        super(DefaultSchemaResolverConfig.configDef(), originals);
    }

    public String getRegistryUrl() {
        return this.getString("apicurio.registry.url");
    }

    public String getTokenEndpoint() {
        return this.getString("apicurio.auth.service.token.endpoint");
    }

    public String getAuthServiceUrl() {
        return this.getString("apicurio.auth.service.url");
    }

    public String getAuthRealm() {
        return this.getString("apicurio.auth.realm");
    }

    public String getAuthClientId() {
        return this.getString("apicurio.auth.client.id");
    }

    public String getAuthClientSecret() {
        return this.getString("apicurio.auth.client.secret");
    }

    public String getAuthUsername() {
        return this.getString("apicurio.auth.username");
    }

    public String getAuthPassword() {
        return this.getString("apicurio.auth.password");
    }

    public Object getArtifactResolverStrategy() {
        return this.get("apicurio.registry.artifact-resolver-strategy");
    }

    public boolean autoRegisterArtifact() {
        return this.getBoolean("apicurio.registry.auto-register");
    }

    public String autoRegisterArtifactIfExists() {
        return this.getString("apicurio.registry.auto-register.if-exists");
    }

    public boolean findLatest() {
        return this.getBoolean("apicurio.registry.find-latest");
    }

    public Duration getCheckPeriod() {
        return DefaultSchemaResolverConfig.extractDurationMillis(this.get("apicurio.registry.check-period-ms"), "apicurio.registry.check-period-ms");
    }

    public long getRetryCount() {
        long result = DefaultSchemaResolverConfig.extractLong(this.get("apicurio.registry.retry-count"), "apicurio.registry.retry-count");
        if (result < 0L) {
            throw new IllegalArgumentException("Config param 'apicurio.registry.retry-count' must be non-negative. Got '" + result + "'.");
        }
        return result;
    }

    public Duration getRetryBackoff() {
        return DefaultSchemaResolverConfig.extractDurationMillis(this.get("apicurio.registry.retry-backoff-ms"), "apicurio.registry.retry-backoff-ms");
    }

    public String getExplicitArtifactGroupId() {
        return this.getString("apicurio.registry.artifact.group-id");
    }

    public String getExplicitArtifactId() {
        return this.getString("apicurio.registry.artifact.artifact-id");
    }

    public String getExplicitArtifactVersion() {
        Object version = this.originals().get("apicurio.registry.artifact.version");
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    private static Duration extractDurationMillis(Object value, String configurationName) {
        long result;
        Objects.requireNonNull(value);
        Objects.requireNonNull(configurationName);
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else if (value instanceof Duration) {
            result = ((Duration)value).toMillis();
        } else {
            throw new IllegalArgumentException("Config param '" + configurationName + "' type unsupported. Expected a Number, String, or Duration. Got '" + value + "'.");
        }
        if (result < 0L) {
            throw new IllegalArgumentException("Config param '" + configurationName + "' represents a duration, which must be non-negative. Got '" + value + "'.");
        }
        return Duration.ofMillis(result);
    }

    private static long extractLong(Object value, String configurationName) {
        long result;
        Objects.requireNonNull(value);
        Objects.requireNonNull(configurationName);
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else {
            throw new IllegalArgumentException("Config param '" + configurationName + "' type unsupported. Expected a Number or String. Got '" + value + "'.");
        }
        return result;
    }
}

