/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.utils;

import java.util.function.Consumer;

public class Utils {
    public static <T> Class<T> loadClass(String javaType) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(javaType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(javaType);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <V> void instantiate(Class<V> type, Object value, Consumer<V> setter) {
        if (value != null) {
            if (type.isInstance(value)) {
                setter.accept(type.cast(value));
            } else if (value instanceof Class && type.isAssignableFrom((Class)value)) {
                setter.accept(Utils.instantiate((Class)value));
            } else if (value instanceof String) {
                Class clazz = Utils.loadClass((String)value);
                setter.accept(Utils.instantiate(clazz));
            } else {
                throw new IllegalArgumentException(String.format("Cannot handle configuration [%s]: %s", type.getName(), value));
            }
        }
    }

    public static <V> V instantiate(Class<V> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

