/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.headers;

import io.apicurio.registry.utils.IoUtil;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class MessageTypeSerdeHeaders {
    private final String messageTypeHeaderName;

    public MessageTypeSerdeHeaders(Map<String, Object> configs, boolean isKey) {
        this.messageTypeHeaderName = isKey ? (String)configs.getOrDefault("apicurio.registry.headers.key.msgType.name", "apicurio.key.msgType") : (String)configs.getOrDefault("apicurio.registry.headers.value.msgType.name", "apicurio.value.msgType");
    }

    public String getMessageType(Headers headers) {
        Header header = headers.lastHeader(this.messageTypeHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }

    public void addMessageTypeHeader(Headers headers, String messageType) {
        headers.add(this.messageTypeHeaderName, IoUtil.toBytes((String)messageType));
    }
}

