/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroEncoding;
import io.apicurio.registry.serde.avro.AvroKafkaSerdeConfig;
import io.apicurio.registry.serde.avro.AvroSchemaParser;
import io.apicurio.registry.serde.avro.AvroSerdeHeaders;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.header.Headers;

public class AvroKafkaDeserializer<U>
extends AbstractKafkaDeserializer<Schema, U> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private AvroSchemaParser parser = new AvroSchemaParser();
    private AvroDatumProvider<U> avroDatumProvider;
    private AvroEncoding configEncoding;
    private AvroSerdeHeaders avroHeaders;

    public AvroKafkaDeserializer() {
    }

    public AvroKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    private AvroKafkaDeserializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        AvroKafkaSerdeConfig config = new AvroKafkaSerdeConfig(configs);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        this.configEncoding = config.getAvroEncoding();
        Class<?> adp = config.getAvroDatumProvider();
        Consumer<AvroDatumProvider> consumer = this::setAvroDatumProvider;
        Utils.instantiate(AvroDatumProvider.class, adp, consumer);
        this.avroDatumProvider.configure(config);
        this.avroHeaders = new AvroSerdeHeaders(isKey);
    }

    public SchemaParser<Schema> schemaParser() {
        return this.parser;
    }

    protected U readData(ParsedSchema<Schema> schema, ByteBuffer buffer, int start, int length) {
        return this.readData(null, schema, buffer, start, length);
    }

    protected U readData(Headers headers, ParsedSchema<Schema> schema, ByteBuffer buffer, int start, int length) {
        String encodingHeader;
        AvroEncoding encoding = null;
        if (headers != null && (encodingHeader = this.avroHeaders.getEncoding(headers)) != null) {
            encoding = AvroEncoding.valueOf(encodingHeader);
        }
        if (encoding == null) {
            encoding = this.configEncoding;
        }
        try {
            DatumReader<U> reader = this.avroDatumProvider.createDatumReader((Schema)schema.getParsedSchema());
            if (encoding == AvroEncoding.JSON) {
                byte[] msgData = new byte[length];
                System.arraycopy(buffer.array(), start, msgData, 0, length);
                return (U)reader.read(null, (Decoder)this.decoderFactory.jsonDecoder((Schema)schema.getParsedSchema(), (InputStream)new ByteArrayInputStream(msgData)));
            }
            return (U)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

