/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import org.apache.avro.Schema;

public class AvroSchemaParser<U>
implements SchemaParser<Schema, U> {
    private AvroDatumProvider<U> avroDatumProvider;

    public AvroSchemaParser(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = avroDatumProvider;
    }

    public ArtifactType artifactType() {
        return ArtifactType.AVRO;
    }

    public Schema parseSchema(byte[] rawSchema) {
        return AvroSchemaUtils.parse(IoUtil.toString((byte[])rawSchema));
    }

    public ParsedSchema<Schema> getSchemaFromData(Record<U> data) {
        Schema schema = this.avroDatumProvider.toSchema(data.payload());
        return new ParsedSchemaImpl().setParsedSchema((Object)schema).setRawSchema(IoUtil.toBytes((String)schema.toString()));
    }
}

