/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroSchemaUtils;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;

public class ReflectAvroDatumProvider<T>
implements AvroDatumProvider<T> {
    private Schema readerSchema;

    public ReflectAvroDatumProvider() {
    }

    public ReflectAvroDatumProvider(Class<T> clazz) {
        this.readerSchema = AvroSchemaUtils.getReflectSchema(clazz);
    }

    @Override
    public DatumWriter<T> createDatumWriter(T data, Schema schema) {
        return new ReflectDatumWriter(schema);
    }

    @Override
    public DatumReader<T> createDatumReader(Schema schema) {
        if (this.readerSchema == null) {
            return new ReflectDatumReader(schema);
        }
        return new ReflectDatumReader(schema, this.readerSchema);
    }

    @Override
    public Schema toSchema(T data) {
        return AvroSchemaUtils.getReflectSchema(data);
    }
}

