/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.worldturner.medeia.api.SchemaSource;
import com.worldturner.medeia.api.StreamSchemaSource;
import com.worldturner.medeia.api.jackson.MedeiaJacksonApi;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.headers.MessageTypeSerdeHeaders;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaDeserializerConfig;
import io.apicurio.registry.serde.utils.Utils;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaKafkaDeserializer<T>
extends AbstractKafkaDeserializer<SchemaValidator, T>
implements Deserializer<T>,
SchemaParser<SchemaValidator> {
    protected static MedeiaJacksonApi api = new MedeiaJacksonApi();
    protected static ObjectMapper mapper = new ObjectMapper();
    private Boolean validationEnabled;
    private Class<T> specificReturnClass;
    private MessageTypeSerdeHeaders serdeHeaders;

    public JsonSchemaKafkaDeserializer() {
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, SchemaResolver<SchemaValidator, T> schemaResolver) {
        super(client, schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaKafkaDeserializer(SchemaResolver<SchemaValidator, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        JsonSchemaKafkaDeserializerConfig config = new JsonSchemaKafkaDeserializerConfig(configs, isKey);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        this.specificReturnClass = config.getSpecificReturnClass();
        this.serdeHeaders = new MessageTypeSerdeHeaders(new HashMap(configs), isKey);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public SchemaParser<SchemaValidator> schemaParser() {
        return this;
    }

    public ArtifactType artifactType() {
        return ArtifactType.JSON;
    }

    public SchemaValidator parseSchema(byte[] rawSchema) {
        return api.loadSchema((SchemaSource)new StreamSchemaSource(IoUtil.toStream((byte[])rawSchema)));
    }

    protected T readData(ParsedSchema<SchemaValidator> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(null, schema, buffer, start, length);
    }

    protected T readData(Headers headers, ParsedSchema<SchemaValidator> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(headers, schema, buffer, start, length);
    }

    private T internalReadData(Headers headers, ParsedSchema<SchemaValidator> schema, ByteBuffer buffer, int start, int length) {
        byte[] data = new byte[length];
        System.arraycopy(buffer.array(), start, data, 0, length);
        try {
            JsonParser parser = mapper.getFactory().createParser(data);
            if (this.isValidationEnabled()) {
                parser = api.decorateJsonParser((SchemaValidator)schema.getParsedSchema(), parser);
            }
            Class messageType = null;
            if (this.specificReturnClass != null) {
                messageType = this.specificReturnClass;
            } else if (headers == null) {
                JsonNode jsonSchema = mapper.readTree(schema.getRawSchema());
                String javaType = null;
                JsonNode javaTypeNode = jsonSchema.get("javaType");
                if (javaTypeNode != null && !javaTypeNode.isNull()) {
                    javaType = javaTypeNode.textValue();
                }
                messageType = javaType == null ? null : Utils.loadClass(javaType);
            } else {
                String javaType = this.serdeHeaders.getMessageType(headers);
                Class clazz = messageType = javaType == null ? null : Utils.loadClass((String)javaType);
            }
            if (messageType == null) {
                return (T)mapper.readTree(parser);
            }
            return (T)mapper.readValue(parser, messageType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

