/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.worldturner.medeia.api.SchemaSource;
import com.worldturner.medeia.api.StreamSchemaSource;
import com.worldturner.medeia.api.jackson.MedeiaJacksonApi;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaSerializer;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.headers.MessageTypeSerdeHeaders;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaSerializerConfig;
import io.apicurio.registry.serde.strategy.ArtifactResolverStrategy;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSchemaKafkaSerializer<T>
extends AbstractKafkaSerializer<SchemaValidator, T>
implements Serializer<T>,
SchemaParser<SchemaValidator> {
    protected static MedeiaJacksonApi api = new MedeiaJacksonApi();
    protected static ObjectMapper mapper = new ObjectMapper();
    private Boolean validationEnabled;
    private MessageTypeSerdeHeaders serdeHeaders;

    public JsonSchemaKafkaSerializer() {
    }

    public JsonSchemaKafkaSerializer(RegistryClient client, ArtifactResolverStrategy<SchemaValidator> artifactResolverStrategy, SchemaResolver<SchemaValidator, T> schemaResolver) {
        super(client, artifactResolverStrategy, schemaResolver);
    }

    public JsonSchemaKafkaSerializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaKafkaSerializer(SchemaResolver<SchemaValidator, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaKafkaSerializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        JsonSchemaKafkaSerializerConfig config = new JsonSchemaKafkaSerializerConfig(configs);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        this.serdeHeaders = new MessageTypeSerdeHeaders(new HashMap(configs), isKey);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public SchemaParser<SchemaValidator> schemaParser() {
        return this;
    }

    public ArtifactType artifactType() {
        return ArtifactType.JSON;
    }

    public SchemaValidator parseSchema(byte[] rawSchema) {
        return api.loadSchema((SchemaSource)new StreamSchemaSource(IoUtil.toStream((byte[])rawSchema)));
    }

    protected void serializeData(ParsedSchema<SchemaValidator> schema, T data, OutputStream out) throws IOException {
        this.serializeData(null, schema, data, out);
    }

    protected void serializeData(Headers headers, ParsedSchema<SchemaValidator> schema, T data, OutputStream out) throws IOException {
        JsonGenerator generator = mapper.getFactory().createGenerator(out);
        if (this.isValidationEnabled()) {
            generator = api.decorateJsonGenerator((SchemaValidator)schema.getParsedSchema(), generator);
        }
        if (headers != null) {
            this.serdeHeaders.addMessageTypeHeader(headers, data.getClass().getName());
        }
        mapper.writeValue(generator, data);
    }
}

