/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.headers.MessageTypeSerdeHeaders;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaDeserializerConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaValidationUtil;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaKafkaDeserializer<T>
extends AbstractKafkaDeserializer<JsonSchema, T>
implements Deserializer<T>,
SchemaParser<JsonSchema, T> {
    protected static ObjectMapper mapper = new ObjectMapper();
    private Boolean validationEnabled;
    private Class<T> specificReturnClass;
    private MessageTypeSerdeHeaders serdeHeaders;

    public JsonSchemaKafkaDeserializer() {
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, SchemaResolver<JsonSchema, T> schemaResolver) {
        super(client, schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaKafkaDeserializer(SchemaResolver<JsonSchema, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaKafkaDeserializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        JsonSchemaKafkaDeserializerConfig config = new JsonSchemaKafkaDeserializerConfig(configs, isKey);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        this.specificReturnClass = config.getSpecificReturnClass();
        this.serdeHeaders = new MessageTypeSerdeHeaders(new HashMap(configs), isKey);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public SchemaParser<JsonSchema, T> schemaParser() {
        return this;
    }

    public ArtifactType artifactType() {
        return ArtifactType.JSON;
    }

    public JsonSchema parseSchema(byte[] rawSchema) {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        return factory.getSchema(IoUtil.toStream((byte[])rawSchema));
    }

    public ParsedSchema<JsonSchema> getSchemaFromData(Record<T> data) {
        return null;
    }

    public boolean supportsExtractSchemaFromData() {
        return false;
    }

    protected T readData(ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(null, schema, buffer, start, length);
    }

    protected T readData(Headers headers, ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(headers, schema, buffer, start, length);
    }

    private T internalReadData(Headers headers, ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        byte[] data = new byte[length];
        System.arraycopy(buffer.array(), start, data, 0, length);
        try {
            JsonParser parser = mapper.getFactory().createParser(data);
            if (this.isValidationEnabled()) {
                JsonSchemaValidationUtil.validateDataWithSchema(schema, data, mapper);
            }
            Class messageType = null;
            if (this.specificReturnClass != null) {
                messageType = this.specificReturnClass;
            } else if (headers == null) {
                JsonNode jsonSchema = mapper.readTree(schema.getRawSchema());
                String javaType = null;
                JsonNode javaTypeNode = jsonSchema.get("javaType");
                if (javaTypeNode != null && !javaTypeNode.isNull()) {
                    javaType = javaTypeNode.textValue();
                }
                messageType = javaType == null ? null : Utils.loadClass(javaType);
            } else {
                String javaType = this.serdeHeaders.getMessageType(headers);
                Class clazz = messageType = javaType == null ? null : Utils.loadClass((String)javaType);
            }
            if (messageType == null) {
                return (T)mapper.readTree(parser);
            }
            return (T)mapper.readValue(parser, messageType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

