/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSchema {
    public static final String TYPE = "JSON";
    private static final String SCHEMA_KEYWORD = "$schema";
    private static final Object NONE_MARKER = new Object();
    private final JsonNode jsonNode;
    private transient Schema schemaObj;
    private final Integer version;
    private final Map<String, JsonSchema> resolvedReferences;
    private transient String canonicalString;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public JsonSchema(JsonNode jsonNode) {
        this(jsonNode, Collections.emptyMap(), null);
    }

    public JsonSchema(String schemaString) {
        this(schemaString, Collections.emptyMap(), null);
    }

    public JsonSchema(JsonNode jsonNode, Map<String, JsonSchema> resolvedReferences, Integer version) {
        this.jsonNode = jsonNode;
        this.version = version;
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
    }

    public JsonSchema(String schemaString, Map<String, JsonSchema> resolvedReferences, Integer version) {
        try {
            this.jsonNode = objectMapper.readTree(schemaString);
            this.version = version;
            this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        }
        catch (IOException var6) {
            throw new IllegalArgumentException("Invalid JSON " + schemaString, var6);
        }
    }

    public JsonSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public JsonSchema(Schema schemaObj, Integer version) {
        try {
            this.jsonNode = schemaObj != null ? objectMapper.readTree(schemaObj.toString()) : null;
            this.schemaObj = schemaObj;
            this.version = version;
            this.resolvedReferences = Collections.emptyMap();
        }
        catch (IOException var4) {
            throw new IllegalArgumentException("Invalid JSON " + schemaObj, var4);
        }
    }

    private JsonSchema(JsonNode jsonNode, Schema schemaObj, Integer version, Map<String, JsonSchema> resolvedReferences, String canonicalString) {
        this.jsonNode = jsonNode;
        this.schemaObj = schemaObj;
        this.version = version;
        this.resolvedReferences = resolvedReferences;
        this.canonicalString = canonicalString;
    }

    public JsonSchema copy() {
        return new JsonSchema(this.jsonNode, this.schemaObj, this.version, this.resolvedReferences, this.canonicalString);
    }

    public JsonSchema copy(Integer version) {
        return new JsonSchema(this.jsonNode, this.schemaObj, version, this.resolvedReferences, this.canonicalString);
    }

    public JsonNode toJsonNode() {
        return this.jsonNode;
    }

    public Schema rawSchema() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.schemaObj == null) {
            String id;
            String schema;
            SpecificationVersion spec = SpecificationVersion.DRAFT_7;
            if (this.jsonNode.has(SCHEMA_KEYWORD) && (schema = this.jsonNode.get(SCHEMA_KEYWORD).asText()) != null) {
                spec = SpecificationVersion.lookupByMetaSchemaUrl((String)schema).orElse(SpecificationVersion.DRAFT_7);
            }
            URI idUri = null;
            if (this.jsonNode.has(spec.idKeyword()) && (id = this.jsonNode.get(spec.idKeyword()).asText()) != null) {
                idUri = ReferenceResolver.resolve((URI)null, (String)id);
            }
            SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().useDefaults(true).draftV7Support();
            for (Map.Entry<String, JsonSchema> stringStringEntry : this.resolvedReferences.entrySet()) {
                URI child = ReferenceResolver.resolve((URI)idUri, (String)stringStringEntry.getKey());
                builder.registerSchemaByURI(child, (Object)new JSONObject((Object)stringStringEntry.getValue()));
            }
            JSONObject jsonObject = new JSONObject(this.canonicalString());
            builder.schemaJson(jsonObject);
            SchemaLoader loader = builder.build();
            this.schemaObj = loader.load().build();
        }
        return this.schemaObj;
    }

    public String schemaType() {
        return TYPE;
    }

    public String name() {
        return this.getString("title");
    }

    public String getString(String key) {
        return this.jsonNode.has(key) ? this.jsonNode.get(key).asText() : null;
    }

    public String canonicalString() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.canonicalString == null) {
            try {
                this.canonicalString = objectMapper.writeValueAsString((Object)this.jsonNode);
            }
            catch (IOException var2) {
                throw new IllegalArgumentException("Invalid JSON", var2);
            }
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    public Map<String, JsonSchema> resolvedReferences() {
        return this.resolvedReferences;
    }

    public void validate(Object value) throws JsonProcessingException, ValidationException {
        Object primitiveValue = NONE_MARKER;
        if (JsonSchema.isPrimitive(value)) {
            primitiveValue = value;
        } else if (value instanceof BinaryNode) {
            primitiveValue = ((BinaryNode)value).asText();
        } else if (value instanceof BooleanNode) {
            primitiveValue = ((BooleanNode)value).asBoolean();
        } else if (value instanceof NullNode) {
            primitiveValue = null;
        } else if (value instanceof NumericNode) {
            primitiveValue = ((NumericNode)value).numberValue();
        } else if (value instanceof TextNode) {
            primitiveValue = ((TextNode)value).asText();
        }
        if (primitiveValue != NONE_MARKER) {
            this.rawSchema().validate(primitiveValue);
        } else {
            Object jsonObject = value instanceof ArrayNode ? objectMapper.treeToValue((TreeNode)((ArrayNode)value), JSONArray.class) : (value instanceof ObjectNode ? new JSONObject(value.toString()) : (value instanceof JsonNode ? objectMapper.treeToValue((TreeNode)((JsonNode)value), JSONObject.class) : (value.getClass().isArray() ? objectMapper.convertValue(value, JSONArray.class) : (value instanceof JSONObject ? value : objectMapper.convertValue(value, JSONObject.class)))));
            this.rawSchema().validate(jsonObject);
            if (this.schemaObj instanceof ObjectSchema && jsonObject instanceof JSONObject) {
                for (Map.Entry schema : ((ObjectSchema)this.schemaObj).getPropertySchemas().entrySet()) {
                    if (!(schema.getValue() instanceof ReferenceSchema)) continue;
                    this.resolvedReferences.get(((ReferenceSchema)schema.getValue()).getReferenceValue()).validate(((JSONObject)jsonObject).get((String)schema.getKey()));
                }
            }
        }
    }

    private static boolean isPrimitive(Object value) {
        return value == null || value instanceof Boolean || value instanceof Number || value instanceof String;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            JsonSchema that = (JsonSchema)o;
            return Objects.equals(this.jsonNode, that.jsonNode) && Objects.equals(this.resolvedReferences, that.resolvedReferences) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.jsonNode, this.resolvedReferences, this.version);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }
}

