/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.protobuf;

import com.google.protobuf.Message;
import io.apicurio.registry.protobuf.ProtobufDifference;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rules.compatibility.protobuf.ProtobufCompatibilityCheckerLibrary;
import io.apicurio.registry.serde.AbstractKafkaSerializer;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.protobuf.ProtobufKafkaSerializerConfig;
import io.apicurio.registry.serde.protobuf.ProtobufSchemaParser;
import io.apicurio.registry.serde.protobuf.ProtobufSerdeHeaders;
import io.apicurio.registry.serde.protobuf.ref.RefOuterClass;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;

public class ProtobufKafkaSerializer<U extends Message>
extends AbstractKafkaSerializer<ProtobufSchema, U> {
    private Boolean validationEnabled;
    private ProtobufSerdeHeaders serdeHeaders;
    private ProtobufSchemaParser<U> parser = new ProtobufSchemaParser();

    public ProtobufKafkaSerializer() {
    }

    public ProtobufKafkaSerializer(RegistryClient client, ArtifactReferenceResolverStrategy<ProtobufSchema, U> artifactResolverStrategy, SchemaResolver<ProtobufSchema, U> schemaResolver) {
        super(client, artifactResolverStrategy, schemaResolver);
    }

    public ProtobufKafkaSerializer(RegistryClient client) {
        super(client);
    }

    public ProtobufKafkaSerializer(SchemaResolver<ProtobufSchema, U> schemaResolver) {
        super(schemaResolver);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        ProtobufKafkaSerializerConfig config = new ProtobufKafkaSerializerConfig(configs);
        super.configure((BaseKafkaSerDeConfig)config, isKey);
        this.serdeHeaders = new ProtobufSerdeHeaders(new HashMap<String, Object>(configs), isKey);
        this.validationEnabled = config.validationEnabled();
    }

    public SchemaParser<ProtobufSchema, U> schemaParser() {
        return this.parser;
    }

    protected void serializeData(ParsedSchema<ProtobufSchema> schema, U data, OutputStream out) throws IOException {
        this.serializeData((Headers)null, schema, data, out);
    }

    protected void serializeData(Headers headers, ParsedSchema<ProtobufSchema> schema, U data, OutputStream out) throws IOException {
        if (this.validationEnabled.booleanValue()) {
            if (schema.getParsedSchema() != null && ((ProtobufSchema)schema.getParsedSchema()).getFileDescriptor().findMessageTypeByName(data.getDescriptorForType().getName()) == null) {
                throw new SerializationException("Missing message type " + data.getDescriptorForType().getName() + " in the protobuf schema");
            }
            List<ProtobufDifference> diffs = this.validate(schema, data);
            if (!diffs.isEmpty()) {
                throw new SerializationException("The data to send is not compatible with the schema. " + diffs);
            }
        }
        if (headers != null) {
            this.serdeHeaders.addMessageTypeHeader(headers, data.getClass().getName());
            this.serdeHeaders.addProtobufTypeNameHeader(headers, data.getDescriptorForType().getName());
        } else {
            RefOuterClass.Ref ref = RefOuterClass.Ref.newBuilder().setName(data.getDescriptorForType().getName()).build();
            ref.writeDelimitedTo(out);
        }
        data.writeTo(out);
    }

    private List<ProtobufDifference> validate(ParsedSchema<ProtobufSchema> schemaFromRegistry, U data) {
        ProtobufFile fileBefore = ((ProtobufSchema)schemaFromRegistry.getParsedSchema()).getProtobufFile();
        ProtobufFile fileAfter = new ProtobufFile(this.parser.toProtoFileElement(data.getDescriptorForType().getFile()));
        ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
        return checker.findDifferences();
    }
}

