/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.protobuf;

import io.apicurio.registry.serde.headers.MessageTypeSerdeHeaders;
import io.apicurio.registry.utils.IoUtil;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class ProtobufSerdeHeaders
extends MessageTypeSerdeHeaders {
    private String messageTypeNameHeaderName = "apicurio.protobuf.type";

    public ProtobufSerdeHeaders(Map<String, Object> configs, boolean isKey) {
        super(configs, isKey);
        if (isKey) {
            this.messageTypeNameHeaderName = this.messageTypeNameHeaderName + ".key";
        }
    }

    public String getProtobufTypeName(Headers headers) {
        Header header = headers.lastHeader(this.messageTypeNameHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }

    public void addProtobufTypeNameHeader(Headers headers, String protobufTypeName) {
        headers.add(this.messageTypeNameHeaderName, IoUtil.toBytes((String)protobufTypeName));
    }
}

