/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.protobuf.ProtobufKafkaDeserializerConfig;
import io.apicurio.registry.serde.protobuf.ProtobufSchemaParser;
import io.apicurio.registry.serde.protobuf.ProtobufSerdeHeaders;
import io.apicurio.registry.serde.protobuf.ref.RefOuterClass;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;

public class ProtobufKafkaDeserializer<U extends Message>
extends AbstractKafkaDeserializer<ProtobufSchema, U> {
    private static final String PROTOBUF_PARSE_METHOD = "parseFrom";
    private ProtobufSchemaParser<U> parser = new ProtobufSchemaParser();
    private Class<?> specificReturnClass;
    private Method specificReturnClassParseMethod;
    private boolean deriveClass;
    private Map<String, Method> parseMethodsCache = new ConcurrentHashMap<String, Method>();
    private ProtobufSerdeHeaders serdeHeaders;

    public ProtobufKafkaDeserializer() {
    }

    public ProtobufKafkaDeserializer(RegistryClient client, SchemaResolver<ProtobufSchema, U> schemaResolver) {
        super(client, schemaResolver);
    }

    public ProtobufKafkaDeserializer(RegistryClient client) {
        super(client);
    }

    public ProtobufKafkaDeserializer(SchemaResolver<ProtobufSchema, U> schemaResolver) {
        super(schemaResolver);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        ProtobufKafkaDeserializerConfig config;
        block4: {
            config = new ProtobufKafkaDeserializerConfig(configs, isKey);
            super.configure((BaseKafkaSerDeConfig)config, isKey);
            this.specificReturnClass = config.getSpecificReturnClass();
            try {
                if (this.specificReturnClass == null) break block4;
                if (this.specificReturnClass.equals(DynamicMessage.class)) {
                    this.specificReturnClassParseMethod = this.specificReturnClass.getDeclaredMethod(PROTOBUF_PARSE_METHOD, Descriptors.Descriptor.class, InputStream.class);
                    break block4;
                }
                if (!this.specificReturnClass.equals(Object.class)) {
                    this.specificReturnClassParseMethod = this.specificReturnClass.getDeclaredMethod(PROTOBUF_PARSE_METHOD, InputStream.class);
                    break block4;
                }
                throw new ConfigException("Class " + this.specificReturnClass.getCanonicalName() + " is not a valid protobuf message class");
            }
            catch (Exception e) {
                throw new ConfigException("Class " + this.specificReturnClass.getCanonicalName() + " is not a valid protobuf message class", (Object)e);
            }
        }
        this.deriveClass = config.deriveClass();
        this.serdeHeaders = new ProtobufSerdeHeaders(new HashMap<String, Object>(configs), isKey);
    }

    public SchemaParser<ProtobufSchema, U> schemaParser() {
        return this.parser;
    }

    protected U readData(Headers headers, ParsedSchema<ProtobufSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(headers, schema, buffer, start, length);
    }

    protected U readData(ParsedSchema<ProtobufSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(null, schema, buffer, start, length);
    }

    protected U internalReadData(Headers headers, ParsedSchema<ProtobufSchema> schema, ByteBuffer buff, int start, int length) {
        try {
            String messageTypeHeader;
            String messageTypeName;
            byte[] bytes = new byte[length];
            System.arraycopy(buff.array(), start, bytes, 0, length);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            Descriptors.Descriptor descriptor = null;
            if (headers != null && (messageTypeName = this.serdeHeaders.getProtobufTypeName(headers)) != null) {
                descriptor = ((ProtobufSchema)schema.getParsedSchema()).getFileDescriptor().findMessageTypeByName(messageTypeName);
            }
            if (descriptor == null) {
                try {
                    RefOuterClass.Ref ref = RefOuterClass.Ref.parseDelimitedFrom(is);
                    descriptor = ((ProtobufSchema)schema.getParsedSchema()).getFileDescriptor().findMessageTypeByName(ref.getName());
                }
                catch (IOException e) {
                    is = new ByteArrayInputStream(bytes);
                    descriptor = (Descriptors.Descriptor)((ProtobufSchema)schema.getParsedSchema()).getFileDescriptor().getMessageTypes().get(0);
                }
            }
            if (this.specificReturnClassParseMethod != null) {
                try {
                    if (this.specificReturnClass.equals(DynamicMessage.class)) {
                        return (U)((Message)this.specificReturnClassParseMethod.invoke(null, descriptor, is));
                    }
                    return (U)((Message)this.specificReturnClassParseMethod.invoke(null, is));
                }
                catch (Exception e) {
                    throw new ConfigException("Not a valid protobuf builder", (Object)e);
                }
            }
            if (this.deriveClass) {
                String className = this.deriveClassFromDescriptor(descriptor);
                if (className != null) {
                    return this.invokeParseMethod(is, className);
                }
            } else if (headers != null && (messageTypeHeader = this.serdeHeaders.getMessageType(headers)) != null) {
                return this.invokeParseMethod(is, messageTypeHeader);
            }
            return (U)DynamicMessage.parseFrom(descriptor, (InputStream)is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private U invokeParseMethod(InputStream buffer, String className) {
        try {
            Method parseMethod = this.parseMethodsCache.computeIfAbsent(className, k -> {
                Class protobufClass = Utils.loadClass((String)className);
                try {
                    return protobufClass.getDeclaredMethod(PROTOBUF_PARSE_METHOD, InputStream.class);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new SerializationException("Class " + className + " is not a valid protobuf message class", (Throwable)e);
                }
            });
            return (U)((Message)parseMethod.invoke(null, buffer));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.parseMethodsCache.remove(className);
            throw new SerializationException("Not a valid protobuf builder", (Throwable)e);
        }
    }

    public String deriveClassFromDescriptor(Descriptors.Descriptor des) {
        Descriptors.Descriptor descriptor = des;
        Descriptors.FileDescriptor fd = descriptor.getFile();
        DescriptorProtos.FileOptions o = fd.getOptions();
        String p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        String outer = "";
        if (!o.getJavaMultipleFiles()) {
            if (o.hasJavaOuterClassname()) {
                outer = o.getJavaOuterClassname();
            } else {
                return null;
            }
        }
        StringBuilder inner = new StringBuilder();
        while (descriptor != null) {
            if (inner.length() == 0) {
                inner.insert(0, descriptor.getName());
            } else {
                inner.insert(0, descriptor.getName() + "$");
            }
            descriptor = descriptor.getContainingType();
        }
        String d1 = !outer.isEmpty() || inner.length() != 0 ? "." : "";
        String d2 = !outer.isEmpty() && inner.length() != 0 ? "$" : "";
        return p + d1 + outer + d2 + inner;
    }
}

