/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;

public class ProtobufSchemaParser<U extends Message>
implements SchemaParser<ProtobufSchema, U> {
    public String artifactType() {
        return "PROTOBUF";
    }

    public ProtobufSchema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<ProtobufSchema>> resolvedReferences) {
        try {
            ProtoFileElement fileElem = ProtoParser.Companion.parse(FileDescriptorUtils.DEFAULT_LOCATION, IoUtil.toString((byte[])rawSchema));
            HashMap dependencies = new HashMap();
            resolvedReferences.forEach((key, value) -> {
                dependencies.put(key, ((ProtobufSchema)value.getParsedSchema()).getProtoFileElement());
                if (value.hasReferences()) {
                    this.addReferencesToDependencies(value.getSchemaReferences(), dependencies);
                }
            });
            MessageElement firstMessage = FileDescriptorUtils.firstMessage((ProtoFileElement)fileElem);
            if (firstMessage != null) {
                try {
                    Descriptors.Descriptor fileDescriptor = FileDescriptorUtils.toDescriptor((String)firstMessage.getName(), (ProtoFileElement)fileElem, dependencies);
                    return new ProtobufSchema(fileDescriptor.getFile(), fileElem);
                }
                catch (IllegalStateException ise) {
                    return this.getFileDescriptorFromElement(fileElem);
                }
            }
            return this.getFileDescriptorFromElement(fileElem);
        }
        catch (Descriptors.DescriptorValidationException pe) {
            throw new SerializationException("Error parsing protobuf schema ", (Throwable)pe);
        }
    }

    private ProtobufSchema getFileDescriptorFromElement(ProtoFileElement fileElem) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor fileDescriptor = FileDescriptorUtils.protoFileToFileDescriptor((ProtoFileElement)fileElem);
        return new ProtobufSchema(fileDescriptor, fileElem);
    }

    private void addReferencesToDependencies(List<ParsedSchema<ProtobufSchema>> schemaReferences, Map<String, ProtoFileElement> dependencies) {
        schemaReferences.forEach(parsedSchema -> {
            dependencies.put(parsedSchema.referenceName(), ((ProtobufSchema)parsedSchema.getParsedSchema()).getProtoFileElement());
            if (parsedSchema.hasReferences()) {
                this.addReferencesToDependencies(parsedSchema.getSchemaReferences(), dependencies);
            }
        });
    }

    public ParsedSchema<ProtobufSchema> getSchemaFromData(Record<U> data) {
        Descriptors.FileDescriptor schemaFileDescriptor = ((Message)data.payload()).getDescriptorForType().getFile();
        ProtoFileElement protoFileElement = this.toProtoFileElement(schemaFileDescriptor);
        ProtobufSchema protobufSchema = new ProtobufSchema(schemaFileDescriptor, protoFileElement);
        byte[] rawSchema = IoUtil.toBytes((String)protoFileElement.toSchema());
        return new ParsedSchemaImpl().setParsedSchema((Object)protobufSchema).setReferenceName(protobufSchema.getFileDescriptor().getName()).setSchemaReferences(this.handleDependencies(schemaFileDescriptor)).setRawSchema(rawSchema);
    }

    public ParsedSchema<ProtobufSchema> getSchemaFromData(Record<U> data, boolean dereference) {
        return this.getSchemaFromData(data);
    }

    private List<ParsedSchema<ProtobufSchema>> handleDependencies(Descriptors.FileDescriptor fileDescriptor) {
        ArrayList<ParsedSchema<ProtobufSchema>> schemaReferences = new ArrayList<ParsedSchema<ProtobufSchema>>();
        fileDescriptor.getDependencies().forEach(referenceFileDescriptor -> {
            ProtoFileElement referenceProtoFileElement = this.toProtoFileElement((Descriptors.FileDescriptor)referenceFileDescriptor);
            ProtobufSchema referenceProtobufSchema = new ProtobufSchema(referenceFileDescriptor, referenceProtoFileElement);
            byte[] rawSchema = IoUtil.toBytes((String)referenceProtoFileElement.toSchema());
            ParsedSchemaImpl referencedSchema = new ParsedSchemaImpl().setParsedSchema((Object)referenceProtobufSchema).setReferenceName(referenceProtobufSchema.getFileDescriptor().getName()).setSchemaReferences(this.handleDependencies((Descriptors.FileDescriptor)referenceFileDescriptor)).setRawSchema(rawSchema);
            schemaReferences.add((ParsedSchema<ProtobufSchema>)referencedSchema);
        });
        return schemaReferences;
    }

    public ProtoFileElement toProtoFileElement(Descriptors.FileDescriptor fileDescriptor) {
        return FileDescriptorUtils.fileDescriptorToProtoFile((DescriptorProtos.FileDescriptorProto)fileDescriptor.toProto());
    }
}

